/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.values;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mchorse.aperture.camera.json.ModifierSerializer;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.values.ValueModifier;
import mchorse.mclib.config.values.Value;

public class ValueModifiers
extends Value {
    private List<AbstractModifier> modifiers = new ArrayList<AbstractModifier>();

    public ValueModifiers(String id) {
        super(id);
    }

    public void add(AbstractModifier modifier) {
        this.modifiers.add(modifier);
        this.addSubValue(new ValueModifier(String.valueOf(this.modifiers.size() - 1), modifier));
    }

    public void add(int index, AbstractModifier modifier) {
        this.modifiers.add(index, modifier);
        this.sync();
    }

    public AbstractModifier remove(int index) {
        AbstractModifier modifier = this.modifiers.remove(index);
        this.sync();
        return modifier;
    }

    public AbstractModifier get(int index) {
        return this.modifiers.get(index);
    }

    public int size() {
        return this.modifiers.size();
    }

    public int indexOf(AbstractModifier modifier) {
        return this.modifiers.indexOf(modifier);
    }

    public void sync() {
        this.removeAllSubValues();
        int i = 0;
        for (AbstractModifier modifier : this.modifiers) {
            this.addSubValue(new ValueModifier(String.valueOf(i), modifier));
            ++i;
        }
    }

    public void set(List<AbstractModifier> modifiers) {
        this.reset();
        for (AbstractModifier modifier : modifiers) {
            this.add(modifier.copy());
        }
    }

    public Object getValue() {
        ArrayList<AbstractModifier> modifiers = new ArrayList<AbstractModifier>();
        for (AbstractModifier modifier : this.modifiers) {
            modifiers.add(modifier.copy());
        }
        return modifiers;
    }

    public void setValue(Object object) {
        List list;
        if (object instanceof List && ((list = (List)object).isEmpty() || list.get(0) instanceof AbstractModifier)) {
            this.set(list);
        }
    }

    public void reset() {
        this.modifiers.clear();
        this.removeAllSubValues();
    }

    public void copy(Value value) {
        if (value instanceof ValueModifiers) {
            this.set(((ValueModifiers)value).modifiers);
        }
    }

    public void fromJSON(JsonElement element) {
        if (!element.isJsonArray()) {
            return;
        }
        JsonArray array = element.getAsJsonArray();
        this.reset();
        for (JsonElement jsonElement : array) {
            JsonObject object;
            AbstractModifier modifier;
            if (!jsonElement.isJsonObject() || (modifier = ModifierSerializer.fromJSON(object = jsonElement.getAsJsonObject())) == null) continue;
            this.add(modifier);
        }
    }

    public JsonElement toJSON() {
        JsonArray array = new JsonArray();
        for (AbstractModifier modifier : this.modifiers) {
            array.add((JsonElement)ModifierSerializer.toJSON(modifier));
        }
        return array;
    }

    public void fromBytes(ByteBuf buffer) {
        this.reset();
        int c = buffer.readInt();
        for (int i = 0; i < c; ++i) {
            AbstractModifier modifier = ModifierSerializer.fromBytes(buffer);
            if (modifier == null) continue;
            this.add(modifier);
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.modifiers.size());
        for (AbstractModifier modifier : this.modifiers) {
            ModifierSerializer.toBytes(modifier, buffer);
        }
    }
}

