/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.values;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import mchorse.aperture.camera.json.ModifierSerializer;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.mclib.config.values.Value;

public class ValueModifier
extends Value {
    private AbstractModifier modifier;

    public ValueModifier(String id, AbstractModifier modifier) {
        super(id);
        this.assign(modifier);
    }

    public void assign(AbstractModifier modifier) {
        this.modifier = modifier;
        this.removeAllSubValues();
        if (modifier != null) {
            for (Value value : modifier.getProperties()) {
                this.addSubValue(value);
            }
        }
    }

    public AbstractModifier get() {
        return this.modifier;
    }

    public void set(AbstractModifier modifier) {
        if (modifier != null) {
            this.assign(modifier.copy());
        }
    }

    public Object getValue() {
        return this.modifier.copy();
    }

    public void setValue(Object object) {
        if (object instanceof AbstractModifier) {
            this.set((AbstractModifier)object);
        }
    }

    public void reset() {
        this.assign(null);
    }

    public void copy(Value value) {
        if (value instanceof ValueModifier) {
            this.setValue(((ValueModifier)value).get());
        }
    }

    public void fromJSON(JsonElement element) {
        if (!element.isJsonObject()) {
            return;
        }
        JsonObject object = element.getAsJsonObject();
        AbstractModifier modifier = ModifierSerializer.fromJSON(object);
        if (modifier != null) {
            this.assign(modifier);
        }
    }

    public JsonElement toJSON() {
        return ModifierSerializer.toJSON(this.modifier);
    }

    public void fromBytes(ByteBuf buffer) {
        this.assign(ModifierSerializer.fromBytes(buffer));
    }

    public void toBytes(ByteBuf buffer) {
        ModifierSerializer.toBytes(this.modifier, buffer);
    }
}

