/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.values;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import mchorse.aperture.camera.data.InterpolationType;
import mchorse.mclib.config.values.Value;

public class ValueInterpolationType
extends Value {
    private InterpolationType interp = InterpolationType.HERMITE;

    public ValueInterpolationType(String id) {
        super(id);
    }

    public InterpolationType get() {
        return this.interp;
    }

    public void set(InterpolationType interp) {
        this.interp = interp;
        this.saveLater();
    }

    public Object getValue() {
        return this.interp;
    }

    public void setValue(Object object) {
        if (object instanceof InterpolationType) {
            this.set((InterpolationType)((Object)object));
        }
    }

    public void reset() {
        this.interp = InterpolationType.HERMITE;
    }

    public void valueFromJSON(JsonElement element) {
        for (InterpolationType type : InterpolationType.values()) {
            if (!type.name.equals(element.getAsString())) continue;
            this.interp = type;
            break;
        }
    }

    public JsonElement valueToJSON() {
        return new JsonPrimitive(this.interp.name);
    }

    public void copy(Value value) {
        if (value instanceof ValueInterpolationType) {
            this.set(((ValueInterpolationType)value).get());
        }
    }

    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.interp = InterpolationType.values()[buffer.readInt()];
    }

    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.interp.ordinal());
    }
}

