/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.values;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.json.FixtureSerializer;
import mchorse.aperture.camera.values.ValueFixture;
import mchorse.mclib.config.values.Value;

public class ValueFixtures
extends Value {
    private List<ValueFixture> fixtures = new ArrayList<ValueFixture>();

    public ValueFixtures(String id) {
        super(id);
    }

    public void add(AbstractFixture fixture) {
        ValueFixture value = new ValueFixture(String.valueOf(this.fixtures.size()), fixture);
        this.fixtures.add(value);
        this.addSubValue(value);
    }

    public void add(int index, AbstractFixture fixture) {
        this.fixtures.add(index, new ValueFixture("", fixture));
        this.sync();
    }

    public AbstractFixture remove(int index) {
        ValueFixture fixture = this.fixtures.remove(index);
        this.sync();
        return fixture.get();
    }

    public AbstractFixture get(int index) {
        return this.fixtures.get(index).get();
    }

    public int size() {
        return this.fixtures.size();
    }

    public int indexOf(AbstractFixture fixture) {
        for (int i = 0; i < this.fixtures.size(); ++i) {
            if (fixture != this.fixtures.get(i).get()) continue;
            return i;
        }
        return -1;
    }

    public void sync() {
        ArrayList<ValueFixture> fixtures = new ArrayList<ValueFixture>();
        this.removeAllSubValues();
        for (int i = 0; i < this.fixtures.size(); ++i) {
            ValueFixture fixture = new ValueFixture(String.valueOf(i), this.fixtures.get(i).get());
            this.addSubValue(fixture);
            fixtures.add(fixture);
        }
        this.fixtures = fixtures;
    }

    public List<ValueFixture> get() {
        return this.fixtures;
    }

    public void set(List<ValueFixture> fixtures) {
        this.reset();
        for (ValueFixture fixture : fixtures) {
            this.add(fixture.get().copy());
        }
    }

    public Object getValue() {
        ArrayList<AbstractFixture> fixtures = new ArrayList<AbstractFixture>();
        for (ValueFixture fixture : this.fixtures) {
            fixtures.add(fixture.get().copy());
        }
        return fixtures;
    }

    public void setValue(Object object) {
        List list;
        if (object instanceof List && ((list = (List)object).isEmpty() || list.get(0) instanceof ValueFixture)) {
            this.set(list);
        }
    }

    public void reset() {
        this.fixtures.clear();
        this.removeAllSubValues();
    }

    public void copy(Value value) {
        if (value instanceof ValueFixtures) {
            this.set(((ValueFixtures)value).fixtures);
        }
    }

    public void fromJSON(JsonElement element) {
        if (!element.isJsonArray()) {
            return;
        }
        JsonArray array = element.getAsJsonArray();
        this.reset();
        for (JsonElement jsonElement : array) {
            JsonObject object;
            AbstractFixture fixture;
            if (!jsonElement.isJsonObject() || (fixture = FixtureSerializer.fromJSON(object = jsonElement.getAsJsonObject())) == null) continue;
            this.add(fixture);
        }
    }

    public JsonElement toJSON() {
        JsonArray array = new JsonArray();
        for (ValueFixture fixture : this.fixtures) {
            array.add((JsonElement)FixtureSerializer.toJSON(fixture.get()));
        }
        return array;
    }

    public void fromBytes(ByteBuf buffer) {
        this.reset();
        int c = buffer.readInt();
        for (int i = 0; i < c; ++i) {
            AbstractFixture fixture = FixtureSerializer.fromBytes(buffer);
            if (fixture == null) continue;
            this.add(fixture);
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.fixtures.size());
        for (ValueFixture fixture : this.fixtures) {
            FixtureSerializer.toBytes(fixture.get(), buffer);
        }
    }
}

