/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.values;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mchorse.aperture.camera.values.ValueKeyframeChannel;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.keyframes.KeyframeChannel;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ValueCurves
extends Value {
    private Map<String, KeyframeChannel> curves = new HashMap<String, KeyframeChannel>();

    public ValueCurves(String id) {
        super(id);
    }

    public KeyframeChannel get(String key) {
        return this.curves.get(key);
    }

    public Set<String> keys() {
        return this.curves.keySet();
    }

    public void put(String key, KeyframeChannel channel) {
        boolean contained = this.curves.containsKey(key);
        this.curves.put(key, channel);
        if (contained) {
            ((ValueKeyframeChannel)this.getSubValue(key)).set(channel);
        } else {
            this.addSubValue(new ValueKeyframeChannel(key, channel).setParent(this));
        }
    }

    public void set(Map<String, KeyframeChannel> curves) {
        this.reset();
        for (Map.Entry<String, KeyframeChannel> entry : curves.entrySet()) {
            KeyframeChannel newCurve = new KeyframeChannel();
            newCurve.copy(entry.getValue());
            this.put(entry.getKey(), newCurve);
        }
    }

    public Object getValue() {
        HashMap curves = new HashMap();
        for (Map.Entry entry : curves.entrySet()) {
            KeyframeChannel newCurve = new KeyframeChannel();
            newCurve.copy((KeyframeChannel)entry.getValue());
            curves.put(entry.getKey(), newCurve);
        }
        return curves;
    }

    public void setValue(Object object) {
        Map map;
        if (object instanceof Map && ((map = (Map)object).isEmpty() || map.get(map.keySet().iterator().next()) instanceof KeyframeChannel)) {
            this.set(map);
        }
    }

    public void reset() {
        this.curves.clear();
        this.removeAllSubValues();
    }

    public void copy(Value value) {
        if (value instanceof ValueCurves) {
            this.set(((ValueCurves)value).curves);
        }
    }

    public void fromJSON(JsonElement element) {
        if (!element.isJsonObject()) {
            return;
        }
        JsonObject object = element.getAsJsonObject();
        for (Map.Entry entry : object.entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
            JsonArray curve = ((JsonElement)entry.getValue()).getAsJsonArray();
            KeyframeChannel channel = new KeyframeChannel();
            channel.fromJSON(curve);
            this.put((String)entry.getKey(), channel);
        }
    }

    public JsonElement toJSON() {
        JsonObject object = new JsonObject();
        for (Map.Entry<String, KeyframeChannel> entry : this.curves.entrySet()) {
            object.add(entry.getKey(), entry.getValue().toJSON());
        }
        return object;
    }

    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.curves.clear();
        int c = buffer.readInt();
        for (int i = 0; i < c; ++i) {
            String key = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            KeyframeChannel curve = new KeyframeChannel();
            curve.fromBytes(buffer);
            this.put(key, curve);
        }
    }

    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.curves.size());
        for (Map.Entry<String, KeyframeChannel> entry : this.curves.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getKey());
            entry.getValue().toBytes(buffer);
        }
    }
}

