/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.smooth;

import mchorse.aperture.Aperture;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SmoothCamera {
    public ValueBoolean enabled;
    public float yaw;
    public float pitch;
    public MouseFilter x = new MouseFilter();
    public MouseFilter y = new MouseFilter();
    public float accX;
    public float accY;
    public ValueFloat fricX;
    public ValueFloat fricY;

    public void update(EntityPlayer player, float dx, float dy) {
        this.accX += dx / 10.0f;
        this.accY += dy / 10.0f;
        this.accX *= ((Float)this.fricX.get()).floatValue();
        this.accY *= ((Float)this.fricY.get()).floatValue();
        this.yaw += this.accX;
        this.pitch += this.accY;
        if (((Boolean)Aperture.smoothClampPitch.get()).booleanValue()) {
            this.pitch = MathHelper.func_76131_a((float)this.pitch, (float)-90.0f, (float)90.0f);
        }
        this.x.update(this.yaw);
        this.y.update(this.pitch);
    }

    public void set(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.accY = 0.0f;
        this.accX = 0.0f;
        this.x.set(yaw);
        this.y.set(pitch);
    }

    public float getInterpYaw(float ticks) {
        return Interpolations.cubic((float)this.x.a, (float)this.x.b, (float)this.x.c, (float)this.x.d, (float)ticks);
    }

    public float getInterpPitch(float ticks) {
        return Interpolations.cubic((float)this.y.a, (float)this.y.b, (float)this.y.c, (float)this.y.d, (float)ticks);
    }

    public class MouseFilter {
        public float a;
        public float b;
        public float c;
        public float d;

        public void update(float x) {
            float a = this.a;
            this.a = x - (x - a) * 0.975f;
            this.b = x - (x - a) * 0.95f;
            this.c = x - (x - a) * 0.9f;
            this.d = x - (x - a) * 0.875f;
        }

        public void set(float x) {
            this.c = this.d = x;
            this.b = this.d;
            this.a = this.d;
        }
    }
}

