/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.smooth;

import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.utils.Interpolations;

public class Filter {
    public float acc;
    public float value;
    public float prevValue;
    public ValueFloat friction;
    public ValueFloat factor;

    public void set(float value) {
        this.value = this.prevValue = value;
    }

    public void reset(float value) {
        this.acc = 0.0f;
        this.value = this.prevValue = value;
    }

    public void accelerate(float value) {
        this.acc += value;
        this.acc *= ((Float)this.friction.get()).floatValue();
        if (Math.abs(this.acc) < 0.005f) {
            this.acc = 0.0f;
        }
    }

    public float interpolate(float ticks) {
        this.value += this.acc;
        float result = Interpolations.lerp((float)this.prevValue, (float)this.value, (float)ticks);
        this.prevValue = this.value;
        return result;
    }
}

