/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.smooth;

import mchorse.aperture.Aperture;
import mchorse.aperture.camera.data.StructureBase;
import mchorse.aperture.camera.values.ValueInterpolation;
import mchorse.aperture.camera.values.ValueKeyframeChannel;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MathUtils;

public class Envelope
extends StructureBase {
    public final ValueBoolean enabled = new ValueBoolean("enabled");
    public final ValueBoolean relative = new ValueBoolean("relative", true);
    public final ValueFloat startX = new ValueFloat("startX");
    public final ValueFloat startDuration = new ValueFloat("startDuration", 10.0f);
    public final ValueFloat endX = new ValueFloat("endX");
    public final ValueFloat endDuration = new ValueFloat("endDuration", 10.0f);
    public final ValueInterpolation interpolation = new ValueInterpolation("interpolation");
    public final ValueBoolean keyframes = new ValueBoolean("keyframes");
    public final ValueKeyframeChannel channel = new ValueKeyframeChannel("channel");
    public final ValueBoolean visible = new ValueBoolean("visible");

    public Envelope() {
        this.register((Value)this.enabled);
        this.register((Value)this.relative);
        this.register((Value)this.startX);
        this.register((Value)this.startDuration);
        this.register((Value)this.endX);
        this.register((Value)this.endDuration);
        this.register(this.interpolation);
        this.register((Value)this.keyframes);
        this.register(this.channel);
        this.register((Value)this.visible);
        this.channel.get().insert(0L, 0.0);
        this.channel.get().insert((long)((Integer)Aperture.duration.get()).intValue(), 1.0);
    }

    public Envelope copy() {
        Envelope envelope = new Envelope();
        envelope.copy(this);
        return envelope;
    }

    public float getStartX(long duration) {
        return ((Float)this.startX.get()).floatValue();
    }

    public float getStartDuration(long duration) {
        return ((Float)this.startX.get()).floatValue() + ((Float)this.startDuration.get()).floatValue();
    }

    public float getEndX(long duration) {
        return (Boolean)this.relative.get() != false ? (float)duration - ((Float)this.endX.get()).floatValue() : ((Float)this.endX.get()).floatValue();
    }

    public float getEndDuration(long duration) {
        return (Boolean)this.relative.get() != false ? (float)duration - ((Float)this.endX.get()).floatValue() - ((Float)this.endDuration.get()).floatValue() : ((Float)this.endX.get()).floatValue() - ((Float)this.endDuration.get()).floatValue();
    }

    public float factorEnabled(long duration, float tick) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return 1.0f;
        }
        return this.factor(duration, tick);
    }

    public float factor(long duration, float tick) {
        float envelope = 0.0f;
        if (((Boolean)this.keyframes.get()).booleanValue()) {
            if (!this.channel.get().isEmpty()) {
                envelope = MathUtils.clamp((float)((float)this.channel.get().interpolate(tick)), (float)0.0f, (float)1.0f);
            }
        } else {
            float startX = ((Float)this.startX.get()).floatValue();
            envelope = Interpolations.envelope((float)tick, (float)startX, (float)(startX + ((Float)this.startDuration.get()).floatValue()), (float)this.getEndDuration(duration), (float)this.getEndX(duration));
            envelope = this.interpolation.get().interpolate(0.0f, 1.0f, envelope);
        }
        return envelope;
    }

    public void breakDown(Envelope original, long offset, long duration) {
        if (((Boolean)original.relative.get()).booleanValue()) {
            original.endX.set((Number)Float.valueOf(((Float)original.endX.get()).floatValue() - (float)(duration - offset)));
        } else {
            original.endX.set((Number)Float.valueOf(((Float)original.endX.get()).floatValue() + (float)offset));
        }
        this.channel.get().moveX(-offset);
        this.startX.set((Number)Float.valueOf(((Float)this.startX.get()).floatValue() - (float)offset));
        if (!((Boolean)this.relative.get()).booleanValue()) {
            this.endX.set((Number)Float.valueOf(((Float)this.endX.get()).floatValue() - (float)offset));
        }
    }
}

