/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.modifiers;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.modifiers.ComponentModifier;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueFloat;

public class ShakeModifier
extends ComponentModifier {
    public final ValueFloat shake = new ValueFloat("shake");
    public final ValueFloat shakeAmount = new ValueFloat("shakeAmount");

    public ShakeModifier() {
        this.register((Value)this.shake);
        this.register((Value)this.shakeAmount);
    }

    @Override
    public void modify(long ticks, long offset, AbstractFixture fixture, float partialTick, float previewPartialTick, CameraProfile profile, Position pos) {
        float shake = ((Float)this.shake.get()).floatValue();
        float amount = ((Float)this.shakeAmount.get()).floatValue();
        float x = ((float)ticks + previewPartialTick) / (shake == 0.0f ? 1.0f : shake);
        boolean isX = this.isActive(0);
        boolean isY = this.isActive(1);
        boolean isZ = this.isActive(2);
        boolean isYaw = this.isActive(3);
        boolean isPitch = this.isActive(4);
        boolean isRoll = this.isActive(5);
        boolean isFov = this.isActive(6);
        if (!(!isYaw || !isPitch || isX || isY || isZ || isRoll || isFov)) {
            float swingX = (float)(Math.sin(x) * Math.sin(x) * Math.cos(x) * Math.cos(x / 2.0f));
            float swingY = (float)(Math.cos(x) * Math.sin(x) * Math.sin(x));
            pos.angle.yaw += swingX * amount;
            pos.angle.pitch += swingY * amount;
        } else {
            if (isX) {
                pos.point.x += Math.sin(x) * (double)amount;
            }
            if (isY) {
                pos.point.y -= Math.sin(x) * (double)amount;
            }
            if (isZ) {
                pos.point.z += Math.cos(x) * (double)amount;
            }
            if (isYaw) {
                pos.angle.yaw = (float)((double)pos.angle.yaw + Math.sin(x) * (double)amount);
            }
            if (isPitch) {
                pos.angle.pitch = (float)((double)pos.angle.pitch + Math.cos(x) * (double)amount);
            }
            if (isRoll) {
                pos.angle.roll = (float)((double)pos.angle.roll + Math.sin(x) * (double)amount);
            }
            if (isFov) {
                pos.angle.fov = (float)((double)pos.angle.fov + Math.cos(x) * (double)amount);
            }
        }
    }

    @Override
    public AbstractModifier create() {
        return new ShakeModifier();
    }
}

