/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.modifiers;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Angle;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.modifiers.EntityModifier;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueFloat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class OrbitModifier
extends EntityModifier {
    public final ValueFloat yaw = new ValueFloat("yaw");
    public final ValueFloat pitch = new ValueFloat("pitch");
    public final ValueFloat distance = new ValueFloat("distance");
    public final ValueBoolean copy = new ValueBoolean("copy");

    public OrbitModifier() {
        this.register((Value)this.yaw);
        this.register((Value)this.pitch);
        this.register((Value)this.distance);
        this.register((Value)this.copy);
    }

    @Override
    public void modify(long ticks, long offset, AbstractFixture fixture, float partialTick, float previewPartialTick, CameraProfile profile, Position pos) {
        if (this.checkForDead()) {
            this.tryFindingEntity();
        }
        if (this.entities == null) {
            return;
        }
        if (fixture != null) {
            fixture.applyFixture(0L, 0.0f, 0.0f, profile, this.position);
        } else {
            this.position.copy(pos);
        }
        float yaw = 0.0f;
        float pitch = 0.0f;
        float distance = ((Float)this.distance.get()).floatValue();
        Entity entity = (Entity)this.entities.get(0);
        if (((Boolean)this.copy.get()).booleanValue()) {
            yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTick;
            pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTick;
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase mob = (EntityLivingBase)entity;
                yaw = mob.field_70758_at + (mob.field_70759_as - mob.field_70758_at) * partialTick;
            }
        }
        float oldYaw = yaw;
        yaw += ((Float)this.yaw.get()).floatValue();
        yaw += pos.angle.yaw - this.position.angle.yaw;
        if (((Boolean)this.copy.get()).booleanValue()) {
            pitch = (float)((double)pitch * (Math.abs((double)(Math.abs(oldYaw - yaw) % 360.0f / 360.0f) - 0.5) * 4.0 - 1.0));
        }
        pitch += ((Float)this.pitch.get()).floatValue();
        pitch += pos.angle.pitch - this.position.angle.pitch;
        distance = (float)((double)distance + (pos.point.z - this.position.point.z));
        float x = (float)(entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTick);
        float y = (float)(entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTick);
        float z = (float)(entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTick);
        float degToPi = (float)Math.PI / 180;
        float cos = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sin = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cos2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float sin2 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        Vec3d look = new Vec3d((double)(sin * cos2), (double)sin2, (double)(cos * cos2));
        pos.point.set(x, y, z);
        x = (float)((double)x + look.field_72450_a * (double)distance);
        y = (float)((double)y + look.field_72448_b * (double)distance);
        z = (float)((double)z + look.field_72449_c * (double)distance);
        double dX = pos.point.x - (double)x;
        double dY = pos.point.y - (double)y;
        double dZ = pos.point.z - (double)z;
        Angle angle = Angle.angle(dX, dY, dZ);
        pos.point.set(x, y, z);
        pos.angle.set(angle.yaw, angle.pitch);
    }

    @Override
    public AbstractModifier create() {
        return new OrbitModifier();
    }
}

