/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.modifiers;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Angle;
import mchorse.aperture.camera.data.Point;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.modifiers.EntityModifier;
import mchorse.aperture.camera.values.ValuePoint;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import net.minecraft.entity.Entity;

public class LookModifier
extends EntityModifier {
    public final ValueBoolean relative = new ValueBoolean("relative");
    public final ValueBoolean atBlock = new ValueBoolean("atBlock");
    public final ValueBoolean forward = new ValueBoolean("forward");
    public final ValuePoint block = new ValuePoint("block", new Point(0.0, 0.0, 0.0));

    public LookModifier() {
        this.register((Value)this.relative);
        this.register((Value)this.atBlock);
        this.register((Value)this.forward);
        this.register(this.block);
    }

    @Override
    public void modify(long ticks, long offset, AbstractFixture fixture, float partialTick, float previewPartialTick, CameraProfile profile, Position pos) {
        if (this.checkForDead()) {
            this.tryFindingEntity();
        }
        boolean atBlock = (Boolean)this.atBlock.get();
        boolean forward = (Boolean)this.forward.get();
        if (this.entities == null && !atBlock && !forward) {
            return;
        }
        if (fixture != null) {
            if (forward) {
                fixture.applyFixture(offset - 1L, partialTick, previewPartialTick, profile, this.position);
            } else {
                fixture.applyFixture(0L, 0.0f, 0.0f, profile, this.position);
            }
        } else {
            this.position.copy(pos);
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (atBlock) {
            Point block = this.block.get();
            x = block.x;
            y = block.y;
            z = block.z;
        } else if (!forward) {
            double sx = 0.0;
            double sy = 0.0;
            double sz = 0.0;
            int size = this.entities.size();
            for (Entity entity : this.entities) {
                sx += entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTick;
                sy += entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTick;
                sz += entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTick;
            }
            x = sx / (double)size;
            y = sy / (double)size;
            z = sz / (double)size;
        }
        Point point = this.offset.get();
        double dX = (x += point.x) - pos.point.x;
        double dY = (y += point.y) - pos.point.y;
        double dZ = (z += point.z) - pos.point.z;
        if (forward) {
            dX = pos.point.x - this.position.point.x;
            dY = pos.point.y - this.position.point.y;
            dZ = pos.point.z - this.position.point.z;
        }
        Angle angle = Angle.angle(dX, dY, dZ);
        float yaw = angle.yaw;
        float pitch = angle.pitch;
        if (((Boolean)this.relative.get()).booleanValue() && !forward) {
            yaw += pos.angle.yaw - this.position.angle.yaw;
            pitch += pos.angle.pitch - this.position.angle.pitch;
        }
        pos.angle.set(yaw, pitch);
    }

    @Override
    public AbstractModifier create() {
        return new LookModifier();
    }
}

