/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.modifiers;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Point;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.modifiers.EntityModifier;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import net.minecraft.entity.Entity;

public class FollowModifier
extends EntityModifier {
    public final ValueBoolean relative = new ValueBoolean("relative");

    public FollowModifier() {
        this.register((Value)this.relative);
    }

    @Override
    public void modify(long ticks, long offset, AbstractFixture fixture, float partialTick, float previewPartialTick, CameraProfile profile, Position pos) {
        if (this.checkForDead()) {
            this.tryFindingEntity();
        }
        if (this.entities == null) {
            return;
        }
        if (fixture != null && ((Boolean)this.relative.get()).booleanValue()) {
            fixture.applyFixture(0L, 0.0f, 0.0f, profile, this.position);
        } else {
            this.position.copy(pos);
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int size = this.entities.size();
        for (Entity entity : this.entities) {
            x += entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTick;
            y += entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTick;
            z += entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTick;
        }
        x = x / (double)size + pos.point.x - this.position.point.x;
        y = y / (double)size + pos.point.y - this.position.point.y;
        z = z / (double)size + pos.point.z - this.position.point.z;
        Point point = this.offset.get();
        pos.point.set(x + point.x, y + point.y, z + point.z);
    }

    @Override
    public AbstractModifier create() {
        return new FollowModifier();
    }
}

