/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.modifiers;

import java.util.Iterator;
import java.util.List;
import mchorse.aperture.camera.data.Point;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.values.ValuePoint;
import mchorse.aperture.utils.EntitySelector;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueString;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityModifier
extends AbstractModifier {
    public Position position = new Position(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public List<Entity> entities;
    public final ValueString selector = new ValueString("selector", "");
    public final ValuePoint offset = new ValuePoint("offset", new Point(0.0, 0.0, 0.0));

    public EntityModifier() {
        this.register((Value)this.selector);
        this.register(this.offset);
    }

    public void tryFindingEntity() {
        this.entities = null;
        String selector = (String)this.selector.get();
        if (selector != null && !selector.isEmpty() && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.tryFindingEntityClient(selector);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void tryFindingEntityClient(String selector) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!selector.contains("@")) {
            selector = "@e[name=" + selector + "]";
        }
        try {
            this.entities = EntitySelector.matchEntities((ICommandSender)player, selector, Entity.class);
            if (this.entities.isEmpty()) {
                this.entities = null;
            }
        }
        catch (Exception e) {
            this.entities = null;
        }
    }

    protected boolean checkForDead() {
        if (this.entities == null) {
            return true;
        }
        Iterator<Entity> it = this.entities.iterator();
        while (it.hasNext()) {
            Entity entity = it.next();
            if (!entity.field_70128_L && entity != Minecraft.func_71410_x().field_71439_g) continue;
            it.remove();
        }
        if (this.entities.isEmpty()) {
            this.entities = null;
        }
        return this.entities == null;
    }
}

