/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.modifiers;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.modifiers.ComponentModifier;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.utils.Interpolations;

public class DragModifier
extends ComponentModifier {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private float roll;
    private float fov;
    public final ValueFloat factor = new ValueFloat("factor", 0.5f, 0.0f, 1.0f);

    public DragModifier() {
        this.register((Value)this.factor);
    }

    public void reset(Position position) {
        this.x = position.point.x;
        this.y = position.point.y;
        this.z = position.point.z;
        this.yaw = position.angle.yaw;
        this.pitch = position.angle.pitch;
        this.roll = position.angle.roll;
        this.fov = position.angle.fov;
    }

    @Override
    public void modify(long ticks, long offset, AbstractFixture fixture, float partialTick, float previewPartialTick, CameraProfile profile, Position pos) {
        if (offset == 0L) {
            this.x = pos.point.x;
            this.y = pos.point.y;
            this.z = pos.point.z;
            this.yaw = pos.angle.yaw;
            this.pitch = pos.angle.pitch;
            this.roll = pos.angle.roll;
            this.fov = pos.angle.fov;
        }
        float factor = ((Float)this.factor.get()).floatValue();
        if (this.isActive(0)) {
            pos.point.x = this.x = Interpolations.lerp((double)this.x, (double)pos.point.x, (double)factor);
        }
        if (this.isActive(1)) {
            pos.point.y = this.y = Interpolations.lerp((double)this.y, (double)pos.point.y, (double)factor);
        }
        if (this.isActive(2)) {
            pos.point.z = this.z = Interpolations.lerp((double)this.z, (double)pos.point.z, (double)factor);
        }
        if (this.isActive(3)) {
            pos.angle.yaw = this.yaw = Interpolations.lerpYaw((float)this.yaw, (float)pos.angle.yaw, (float)factor);
        }
        if (this.isActive(4)) {
            pos.angle.pitch = this.pitch = Interpolations.lerp((float)this.pitch, (float)pos.angle.pitch, (float)factor);
        }
        if (this.isActive(5)) {
            pos.angle.roll = this.roll = Interpolations.lerp((float)this.roll, (float)pos.angle.roll, (float)factor);
        }
        if (this.isActive(6)) {
            pos.angle.fov = this.fov = Interpolations.lerp((float)this.fov, (float)pos.angle.fov, (float)factor);
        }
    }

    @Override
    public AbstractModifier create() {
        return new DragModifier();
    }
}

