/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.modifiers;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueFloat;

public class DollyZoomModifier
extends AbstractModifier {
    public Position position = new Position(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public final ValueFloat focus = new ValueFloat("focus");

    public DollyZoomModifier() {
        this.register((Value)this.focus);
    }

    @Override
    public AbstractModifier create() {
        return new DollyZoomModifier();
    }

    @Override
    public void modify(long ticks, long offset, AbstractFixture fixture, float partialTick, float previewPartialTick, CameraProfile profile, Position pos) {
        if (fixture == null) {
            return;
        }
        fixture.applyFixture(0L, 0.0f, profile, this.position);
        double dist = (double)((Float)this.focus.get()).floatValue() - (double)((Float)this.focus.get()).floatValue() * Math.tan(Math.toRadians((double)Math.max(this.position.angle.fov, 0.01f) / 2.0)) / Math.tan(Math.toRadians((double)Math.max(pos.angle.fov, 0.01f) / 2.0));
        pos.point.x += dist * Math.cos(Math.toRadians(pos.angle.pitch)) * Math.sin(Math.toRadians(-pos.angle.yaw));
        pos.point.y -= dist * Math.sin(Math.toRadians(pos.angle.pitch));
        pos.point.z += dist * Math.cos(Math.toRadians(pos.angle.pitch)) * Math.cos(Math.toRadians(-pos.angle.yaw));
    }
}

