/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.modifiers;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.data.StructureBase;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.values.ValueEnvelope;
import mchorse.aperture.camera.values.ValueModifiers;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;

public abstract class AbstractModifier
extends StructureBase {
    public static final Position temporary = new Position();
    public final ValueBoolean enabled = new ValueBoolean("enabled", true);
    public final ValueEnvelope envelope = new ValueEnvelope("envelope");

    public static boolean applyModifiers(CameraProfile profile, AbstractFixture fixture, long ticks, long offset, float partialTick, float previewPartialTick, AbstractModifier target, Position pos) {
        long duration = fixture == null ? profile.getDuration() : fixture.getDuration();
        ValueModifiers modifiers = fixture == null ? profile.modifiers : fixture.modifiers;
        for (int i = 0; i < modifiers.size(); ++i) {
            AbstractModifier modifier = modifiers.get(i);
            if (modifier == target) {
                return false;
            }
            if (!((Boolean)modifier.enabled.get()).booleanValue()) continue;
            float factor = modifier.envelope.get().factorEnabled(duration, (float)offset + previewPartialTick);
            temporary.copy(pos);
            modifier.modify(ticks, offset, fixture, partialTick, previewPartialTick, profile, temporary);
            if (factor == 0.0f) continue;
            pos.interpolate(temporary, factor);
        }
        return true;
    }

    public AbstractModifier() {
        this.register((Value)this.enabled);
        this.register(this.envelope);
    }

    public abstract void modify(long var1, long var3, AbstractFixture var5, float var6, float var7, CameraProfile var8, Position var9);

    public final AbstractModifier copy() {
        AbstractModifier modifier = this.create();
        modifier.copy(this);
        return modifier;
    }

    public abstract AbstractModifier create();

    public void breakDown(AbstractModifier original, long offset, long duration) {
        this.envelope.get().breakDown(original.envelope.get(), offset, duration);
    }
}

