/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.json;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import mchorse.aperture.camera.ModifierRegistry;
import mchorse.aperture.camera.modifiers.AbstractModifier;

public class ModifierSerializer {
    public static AbstractModifier fromBytes(ByteBuf buffer) {
        try {
            AbstractModifier modifier = ModifierRegistry.fromType(buffer.readByte());
            modifier.fromBytes(buffer);
            return modifier;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void toBytes(AbstractModifier modifier, ByteBuf buffer) {
        buffer.writeByte((int)ModifierRegistry.getType(modifier));
        modifier.toBytes(buffer);
    }

    public static AbstractModifier fromJSON(JsonObject object) {
        String type = object.has("type") && object.get("type").isJsonPrimitive() ? object.get("type").getAsString() : "";
        Class clazz = (Class)ModifierRegistry.NAME_TO_CLASS.get((Object)type);
        if (clazz != null) {
            try {
                AbstractModifier modifier = (AbstractModifier)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                modifier.fromJSON(object);
                return modifier;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static JsonObject toJSON(AbstractModifier modifier) {
        JsonObject object = new JsonObject();
        object.addProperty("type", (String)ModifierRegistry.NAME_TO_CLASS.inverse().get(modifier.getClass()));
        modifier.toJSON(object);
        return object;
    }
}

