/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import mchorse.aperture.camera.FixtureRegistry;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.fixtures.KeyframeFixture;
import mchorse.aperture.camera.fixtures.PathFixture;
import mchorse.aperture.camera.modifiers.RemapperModifier;
import mchorse.aperture.camera.values.ValueKeyframeChannel;
import mchorse.mclib.utils.keyframes.Keyframe;

public class FixtureSerializer {
    public static void toBytes(AbstractFixture fixture, ByteBuf buffer) {
        byte type = (Byte)FixtureRegistry.CLASS_TO_ID.get(fixture.getClass());
        buffer.writeByte((int)type);
        buffer.writeLong(fixture.getDuration());
        fixture.toBytes(buffer);
    }

    public static AbstractFixture fromBytes(ByteBuf buffer) {
        byte type = buffer.readByte();
        long duration = buffer.readLong();
        try {
            AbstractFixture fixture = FixtureRegistry.fromType(type, duration);
            fixture.fromBytes(buffer);
            return fixture;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AbstractFixture fromJSON(JsonObject object) {
        AbstractFixture fixture = null;
        if (object.has("type")) {
            String type = object.get("type").getAsString();
            Class clazz = (Class)FixtureRegistry.NAME_TO_CLASS.get((Object)type);
            if (clazz != null) {
                try {
                    fixture = (AbstractFixture)clazz.getConstructor(Long.TYPE).newInstance(0);
                    fixture.fromJSON(object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (type.equals("path") && fixture != null) {
                JsonElement useFactor;
                if (object.has("perPointDuration") && object.get("perPointDuration").getAsBoolean()) {
                    return FixtureSerializer.convertToKeyframe((PathFixture)fixture, object.getAsJsonArray("points"));
                }
                if (object.has("useFactor") && (useFactor = object.get("useFactor")).isJsonPrimitive() && useFactor.getAsBoolean()) {
                    FixtureSerializer.convertUseFactorToRemapper((PathFixture)fixture, object);
                }
            }
        }
        return fixture;
    }

    private static AbstractFixture convertToKeyframe(PathFixture fixture, JsonArray points) {
        if (points.size() != fixture.size()) {
            return fixture;
        }
        KeyframeFixture keys = fixture.toKeyframe();
        int x = 0;
        int c = fixture.size();
        for (int i = 0; i < c; ++i) {
            JsonObject point = points.get(i).getAsJsonObject();
            for (ValueKeyframeChannel channel : keys.channels) {
                Keyframe frame = channel.get().get(i);
                frame.tick = x;
            }
            if (i == c - 1) continue;
            if (point.has("duration")) {
                x += point.get("duration").getAsInt();
                continue;
            }
            ++x;
        }
        keys.setDuration(x);
        return keys;
    }

    private static void convertUseFactorToRemapper(PathFixture fixture, JsonObject object) {
        RemapperModifier modifier = new RemapperModifier();
        modifier.keyframes.set((Object)true);
        modifier.channel.copy(fixture.speed);
        fixture.useSpeed.set((Object)false);
        fixture.modifiers.add(0, modifier);
    }

    public static JsonObject toJSON(AbstractFixture fixtre) {
        JsonObject object = new JsonObject();
        object.addProperty("type", (String)FixtureRegistry.NAME_TO_CLASS.inverse().get(fixtre.getClass()));
        fixtre.toJSON(object);
        return object;
    }
}

