/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.fixtures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector2d;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Angle;
import mchorse.aperture.camera.data.InterpolationType;
import mchorse.aperture.camera.data.Point;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.fixtures.DollyFixture;
import mchorse.aperture.camera.fixtures.KeyframeFixture;
import mchorse.aperture.camera.values.ValueInterpolationType;
import mchorse.aperture.camera.values.ValueKeyframeChannel;
import mchorse.aperture.camera.values.ValuePositions;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueDouble;
import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.keyframes.KeyframeChannel;
import mchorse.mclib.utils.keyframes.KeyframeEasing;
import mchorse.mclib.utils.keyframes.KeyframeInterpolation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;

public class PathFixture
extends AbstractFixture {
    public static final Vector2d VECTOR = new Vector2d();
    public final ValuePositions points = new ValuePositions("points");
    public final ValueInterpolationType interpolation = new ValueInterpolationType("interpolation");
    public final ValueInterpolationType interpolationAngle = new ValueInterpolationType("interpolationAngle");
    public final ValueBoolean useSpeed = new ValueBoolean("useSpeed", false);
    public final ValueKeyframeChannel speed = new ValueKeyframeChannel("speed");
    public final ValueBoolean circularAutoCenter = new ValueBoolean("circularAutoCenter", true);
    public final ValueDouble circularX = new ValueDouble("circularX", 0.0);
    public final ValueDouble circularZ = new ValueDouble("circularZ", 0.0);
    private float lastTick;
    private Point lastPoint = new Point(0.0, 0.0, 0.0);
    private Point tmpPoint = new Point(0.0, 0.0, 0.0);
    private CachedPosition result = new CachedPosition();
    private List<CachedPosition> cache = new ArrayList<CachedPosition>();
    private boolean disableSpeed = false;

    public PathFixture(long duration) {
        super(duration);
        this.register(this.points);
        this.register(this.interpolation);
        this.register(this.interpolationAngle);
        this.register((Value)this.useSpeed);
        this.register(this.speed);
        this.register((Value)this.circularAutoCenter);
        this.register((Value)this.circularX);
        this.register((Value)this.circularZ);
        this.speed.get().insert(0L, 1.0);
    }

    public KeyframeFixture toKeyframe() {
        int c = this.size();
        if (c <= 1) {
            return null;
        }
        long duration = this.getDuration();
        KeyframeFixture fixture = new KeyframeFixture(duration);
        fixture.copy(this);
        KeyframeInterpolation pos = this.interpolation.get().interp;
        KeyframeInterpolation angle = this.interpolationAngle.get().interp;
        KeyframeEasing posEasing = this.interpolation.get().easing;
        KeyframeEasing angleEasing = this.interpolationAngle.get().easing;
        for (int i = 0; i < this.size(); ++i) {
            Position point = this.points.get(i);
            long x = (int)((float)i / ((float)c - 1.0f) * (float)duration);
            int index = fixture.x.get().insert(x, (double)((float)point.point.x));
            fixture.y.get().insert(x, (double)((float)point.point.y));
            fixture.z.get().insert(x, (double)((float)point.point.z));
            fixture.yaw.get().insert(x, (double)point.angle.yaw);
            fixture.pitch.get().insert(x, (double)point.angle.pitch);
            fixture.roll.get().insert(x, (double)point.angle.roll);
            fixture.fov.get().insert(x, (double)point.angle.fov);
            fixture.x.get().get(index).setInterpolation(pos, posEasing);
            fixture.y.get().get(index).setInterpolation(pos, posEasing);
            fixture.z.get().get(index).setInterpolation(pos, posEasing);
            fixture.yaw.get().get(index).setInterpolation(angle, angleEasing);
            fixture.pitch.get().get(index).setInterpolation(angle, angleEasing);
            fixture.roll.get().get(index).setInterpolation(angle, angleEasing);
            fixture.fov.get().get(index).setInterpolation(angle, angleEasing);
        }
        return fixture;
    }

    @Override
    public void initiate() {
        this.updateSpeedCache();
    }

    public void updateSpeedCache() {
        CachedPosition previous = null;
        this.cache.clear();
        int c = this.size();
        for (int i = 1; i < c; ++i) {
            float target = this.calculateTarget((int)((float)this.getDuration() / (float)c * (float)i));
            this.applyPoint(this.lastPoint, 0, 0.0f);
            previous = this.calculateResult(target, true, previous).copy();
            this.cache.add(previous);
        }
    }

    public void disableSpeed() {
        this.disableSpeed = true;
    }

    public void reenableSpeed() {
        this.disableSpeed = false;
    }

    public Position getPoint(int index) {
        int size = this.size();
        if (size == 0) {
            return new Position(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (index >= size) {
            return this.points.get(size - 1);
        }
        if (index < 0) {
            return this.points.get(0);
        }
        return this.points.get(index);
    }

    public int size() {
        return this.points.size();
    }

    public long getTickForPoint(int index) {
        return (long)((float)index / (float)(this.size() - 1) * (float)this.getDuration());
    }

    @Override
    public void fromPlayer(EntityPlayer player) {
        this.points.add(new Position(player));
    }

    @Override
    public void applyFixture(long ticks, float partialTicks, float previewPartialTick, CameraProfile profile, Position pos) {
        long duration = this.getDuration();
        if (this.points.size() == 0 || duration == 0L) {
            return;
        }
        if (((Boolean)this.useSpeed.get()).booleanValue() && !this.disableSpeed) {
            float tick = (float)ticks + previewPartialTick;
            if (tick != this.lastTick || tick == 0.0f) {
                this.applyPoint(this.lastPoint, 0, 0.0f);
                this.recalculate(tick, pos.angle);
            }
            pos.point.set(this.lastPoint.x, this.lastPoint.y, this.lastPoint.z);
            this.lastTick = tick;
        } else {
            int length = this.size() - 1;
            float x = (float)ticks / (float)this.getDuration() + 1.0f / (float)duration * previewPartialTick;
            x = MathHelper.func_76131_a((float)(x * (float)length), (float)0.0f, (float)length);
            int index = (int)Math.floor(x);
            this.applyAngle(pos.angle, index, x -= (float)index);
            this.applyPoint(pos.point, index, x);
        }
    }

    private CachedPosition recalculate(float tick, Angle angle) {
        float target = this.calculateTarget(tick);
        CachedPosition result = null;
        int c = this.cache.size();
        for (int i = 1; i < c; ++i) {
            CachedPosition current = this.cache.get(i);
            CachedPosition previous = this.cache.get(i - 1);
            if (target < current.distance && target >= previous.distance) {
                result = previous;
                break;
            }
            if (i != c - 1 || !(target >= current.distance)) continue;
            result = current;
        }
        result = this.calculateResult(target, result);
        this.applyAngle(angle, result.index, result.progress);
        return result;
    }

    private CachedPosition calculateResult(float target) {
        return this.calculateResult(target, null);
    }

    private CachedPosition calculateResult(float target, CachedPosition position) {
        return this.calculateResult(target, false, position);
    }

    private CachedPosition calculateResult(float target, boolean haltOnFactorChange, CachedPosition position) {
        int iterations = 0;
        int size = this.size() - 1;
        int index = 0;
        float progress = 0.0f;
        float distance = 0.0f;
        float factor = 0.1f;
        if (position != null) {
            index = position.index;
            progress = position.progress;
            distance = position.distance;
            this.lastPoint.set(position.point);
        }
        float diff = Math.abs(target - distance);
        while (diff > 5.0E-5f) {
            progress += factor;
            if (factor == 0.0f || Math.abs(factor) < 1.0E-7f) {
                this.result.set(index, progress, distance, iterations, this.lastPoint);
                this.applyPoint(this.lastPoint, index, progress);
                return this.result;
            }
            if (progress > 1.0f) {
                if (index >= size) {
                    progress = 1.0f;
                    factor *= -0.5f;
                } else {
                    progress %= 1.0f;
                    ++index;
                }
            } else if (progress < 0.0f) {
                if (index <= 0) {
                    progress = 0.0f;
                    factor *= -0.5f;
                } else {
                    progress = 1.0f + progress % 1.0f;
                    --index;
                }
            }
            this.applyPoint(this.tmpPoint, index, progress);
            double dx = this.tmpPoint.x - this.lastPoint.x;
            double dy = this.tmpPoint.y - this.lastPoint.y;
            double dz = this.tmpPoint.z - this.lastPoint.z;
            this.lastPoint.set(this.tmpPoint.x, this.tmpPoint.y, this.tmpPoint.z);
            distance = (float)((double)distance + Math.sqrt(dx * dx + dy * dy + dz * dz) * (double)(factor > 0.0f ? 1 : -1));
            float delta = Math.abs(target - distance);
            if (progress == 1.0f && index >= size && distance < target) break;
            if (diff < delta) {
                if (haltOnFactorChange) {
                    this.result.set(index, progress, distance, iterations, this.lastPoint);
                    return this.result;
                }
                factor *= -0.5f;
            }
            diff = delta;
            ++iterations;
        }
        this.result.set(index, progress, distance, iterations, this.lastPoint);
        return this.result;
    }

    private float calculateTarget(float tick) {
        float target = 0.0f;
        KeyframeChannel channel = this.speed.get();
        int c = (int)tick;
        for (int i = 0; i < c; ++i) {
            target = (float)((double)target + channel.interpolate((float)i));
        }
        target = (float)((double)target + channel.interpolate(tick) * (double)(tick % 1.0f));
        return target /= 20.0f;
    }

    private void applyPoint(Point point, int index, float progress) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        Position p0 = this.getPoint(index - 1);
        Position p1 = this.getPoint(index);
        Position p2 = this.getPoint(index + 1);
        Position p3 = this.getPoint(index + 2);
        InterpolationType interp = this.interpolation.get();
        if (interp == InterpolationType.CUBIC) {
            x = Interpolations.cubic((double)p0.point.x, (double)p1.point.x, (double)p2.point.x, (double)p3.point.x, (double)progress);
            y = Interpolations.cubic((double)p0.point.y, (double)p1.point.y, (double)p2.point.y, (double)p3.point.y, (double)progress);
            z = Interpolations.cubic((double)p0.point.z, (double)p1.point.z, (double)p2.point.z, (double)p3.point.z, (double)progress);
        } else if (interp == InterpolationType.HERMITE) {
            x = Interpolations.cubicHermite((double)p0.point.x, (double)p1.point.x, (double)p2.point.x, (double)p3.point.x, (double)progress);
            y = Interpolations.cubicHermite((double)p0.point.y, (double)p1.point.y, (double)p2.point.y, (double)p3.point.y, (double)progress);
            z = Interpolations.cubicHermite((double)p0.point.z, (double)p1.point.z, (double)p2.point.z, (double)p3.point.z, (double)progress);
        } else if (interp == InterpolationType.CIRCULAR) {
            int size = this.size();
            if (index >= size) {
                x = p2.point.x;
                y = p2.point.y;
                z = p2.point.z;
            } else if (index < 0) {
                x = p1.point.x;
                y = p1.point.y;
                z = p1.point.z;
            } else {
                Vector2d center = this.getCenter();
                double mx = center.x;
                double mz = center.y;
                Vector2d a0 = this.calculateCircular(mx, mz, index - 1);
                Vector2d a1 = this.calculateCircular(mx, mz, index);
                Vector2d a2 = this.calculateCircular(mx, mz, index + 1);
                Vector2d a3 = this.calculateCircular(mx, mz, index + 2);
                double a = Interpolations.cubicHermite((double)a0.x, (double)a1.x, (double)a2.x, (double)a3.x, (double)progress);
                double d = Interpolations.cubicHermite((double)a0.y, (double)a1.y, (double)a2.y, (double)a3.y, (double)progress);
                a = a / 180.0 * Math.PI;
                x = mx + Math.cos(a) * d;
                y = Interpolations.cubicHermite((double)p0.point.y, (double)p1.point.y, (double)p2.point.y, (double)p3.point.y, (double)progress);
                z = mz + Math.sin(a) * d;
            }
        } else if (interp.interp != null) {
            Interpolation func = interp.function;
            x = func.interpolate(p1.point.x, p2.point.x, (double)progress);
            y = func.interpolate(p1.point.y, p2.point.y, (double)progress);
            z = func.interpolate(p1.point.z, p2.point.z, (double)progress);
        }
        point.set(x, y, z);
    }

    private Vector2d calculateCircular(double mx, double mz, int index) {
        int size = this.size();
        double a = 0.0;
        double d = 0.0;
        double lastA = 0.0;
        if (index < 0) {
            index = 0;
        } else if (index >= size) {
            index = size - 1;
        }
        for (int i = 0; i < size; ++i) {
            Position p = this.points.get(i);
            double dx = p.point.x - mx;
            double dz = p.point.z - mz;
            d = Math.sqrt(dx * dx + dz * dz);
            a = Math.atan2(dz, dx) / Math.PI * 180.0;
            if (a < 0.0) {
                a = 360.0 + a;
            }
            double originalA = a;
            if (Math.abs(a - lastA) > 180.0) {
                a = Interpolations.normalizeYaw((double)lastA, (double)a);
            }
            if (i == index) break;
            lastA = originalA;
        }
        return new Vector2d(a, d);
    }

    public Vector2d getCenter() {
        if (((Boolean)this.circularAutoCenter.get()).booleanValue()) {
            this.calculateCenter(VECTOR);
        } else {
            VECTOR.set(((Double)this.circularX.get()).doubleValue(), ((Double)this.circularZ.get()).doubleValue());
        }
        return VECTOR;
    }

    public Vector2d calculateCenter(Vector2d vector) {
        vector.set(0.0, 0.0);
        for (int i = 0; i < this.size(); ++i) {
            Position position = this.points.get(i);
            vector.x += position.point.x;
            vector.y += position.point.z;
        }
        vector.x /= (double)this.size();
        vector.y /= (double)this.size();
        return vector;
    }

    private void applyAngle(Angle angle, int index, float progress) {
        float yaw = 0.0f;
        float pitch = 0.0f;
        float roll = 0.0f;
        float fov = 0.0f;
        Position p0 = this.getPoint(index - 1);
        Position p1 = this.getPoint(index);
        Position p2 = this.getPoint(index + 1);
        Position p3 = this.getPoint(index + 2);
        InterpolationType interp = this.interpolationAngle.get();
        if (interp == InterpolationType.CUBIC) {
            yaw = Interpolations.cubic((float)p0.angle.yaw, (float)p1.angle.yaw, (float)p2.angle.yaw, (float)p3.angle.yaw, (float)progress);
            pitch = Interpolations.cubic((float)p0.angle.pitch, (float)p1.angle.pitch, (float)p2.angle.pitch, (float)p3.angle.pitch, (float)progress);
            roll = Interpolations.cubic((float)p0.angle.roll, (float)p1.angle.roll, (float)p2.angle.roll, (float)p3.angle.roll, (float)progress);
            fov = Interpolations.cubic((float)p0.angle.fov, (float)p1.angle.fov, (float)p2.angle.fov, (float)p3.angle.fov, (float)progress);
        } else if (interp == InterpolationType.HERMITE) {
            yaw = (float)Interpolations.cubicHermite((double)p0.angle.yaw, (double)p1.angle.yaw, (double)p2.angle.yaw, (double)p3.angle.yaw, (double)progress);
            pitch = (float)Interpolations.cubicHermite((double)p0.angle.pitch, (double)p1.angle.pitch, (double)p2.angle.pitch, (double)p3.angle.pitch, (double)progress);
            roll = (float)Interpolations.cubicHermite((double)p0.angle.roll, (double)p1.angle.roll, (double)p2.angle.roll, (double)p3.angle.roll, (double)progress);
            fov = (float)Interpolations.cubicHermite((double)p0.angle.fov, (double)p1.angle.fov, (double)p2.angle.fov, (double)p3.angle.fov, (double)progress);
        } else {
            Interpolation func = interp.function == null ? Interpolation.LINEAR : interp.function;
            yaw = func.interpolate(p1.angle.yaw, p2.angle.yaw, progress);
            pitch = func.interpolate(p1.angle.pitch, p2.angle.pitch, progress);
            roll = func.interpolate(p1.angle.roll, p2.angle.roll, progress);
            fov = func.interpolate(p1.angle.fov, p2.angle.fov, progress);
        }
        angle.set(yaw, pitch, roll, fov);
    }

    @Override
    public AbstractFixture create(long duration) {
        return new PathFixture(duration);
    }

    @Override
    public void copyByReplacing(AbstractFixture from) {
        super.copyByReplacing(from);
        if (from instanceof DollyFixture) {
            DollyFixture dolly = (DollyFixture)from;
            Position position = new Position();
            from.applyLast(null, position);
            this.points.reset();
            this.points.add(dolly.position.get().copy());
            this.points.add(position);
            this.interpolation.set(InterpolationType.fromInterp(dolly.interp.get()));
            this.interpolationAngle.set(InterpolationType.fromInterp(dolly.interp.get()));
        }
    }

    @Override
    protected void breakDownFixture(AbstractFixture original, long offset) {
        int i;
        super.breakDownFixture(original, offset);
        if (this.points.size() < 2) {
            return;
        }
        PathFixture fixture = (PathFixture)original;
        Position position = new Position();
        original.applyFixture(offset, 0.0f, (CameraProfile)null, position);
        float factor = (float)offset / (float)original.getDuration() * (float)(this.size() - 1);
        int originalPoints = (int)Math.ceil(factor);
        int thisPoints = (int)Math.floor(factor);
        ArrayList<Position> oP = new ArrayList<Position>();
        ArrayList<Position> tP = new ArrayList<Position>();
        for (i = 0; i < originalPoints; ++i) {
            oP.add(fixture.points.get(i).copy());
        }
        oP.add(position.copy());
        for (i = this.points.size() - 1; i > thisPoints; --i) {
            tP.add(this.points.get(i).copy());
        }
        tP.add(position.copy());
        Collections.reverse(tP);
        fixture.points.set(oP);
        this.points.set(tP);
    }

    public static class CachedPosition {
        public int index;
        public float progress;
        public float distance;
        public int iterations;
        public Point point;

        public void set(int index, float progress, float distance, int iterations, Point point) {
            this.index = index;
            this.progress = progress;
            this.distance = distance;
            this.iterations = iterations;
            this.point = point.copy();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CachedPosition) {
                CachedPosition position = (CachedPosition)obj;
                return this.index == position.index && this.progress == position.progress && this.distance == position.distance && this.point.x == position.point.x && this.point.y == position.point.y && this.point.z == position.point.z;
            }
            return super.equals(obj);
        }

        public CachedPosition copy() {
            CachedPosition position = new CachedPosition();
            position.set(this.index, this.progress, this.distance, this.iterations, this.point);
            return position;
        }
    }
}

