/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.fixtures;

import java.util.ArrayList;
import java.util.List;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.data.RenderFrame;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.values.ValueRenderFrames;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.config.values.ValueInt;
import net.minecraft.entity.player.EntityPlayer;

public class ManualFixture
extends AbstractFixture {
    public final ValueFloat speed = new ValueFloat("speed", 1.0f);
    public final ValueInt shift = new ValueInt("shift", 0);
    public final ValueRenderFrames frames = new ValueRenderFrames("frames");
    private List<RenderFrame> recorded = new ArrayList<RenderFrame>();

    public ManualFixture(long duration) {
        super(duration);
        this.register((Value)this.speed);
        this.register((Value)this.shift);
        this.register(this.frames);
    }

    public void recordFrame(EntityPlayer player, float partialTicks) {
        RenderFrame frame = new RenderFrame(player, partialTicks);
        frame.y += (double)player.func_70047_e();
        this.recorded.add(frame);
    }

    public int getEndTick() {
        float speed = ((Float)this.speed.get()).floatValue();
        if (speed <= 0.0f) {
            return 1000000000;
        }
        return (int)((float)(this.frames.get().size() + (Integer)this.shift.get()) / speed);
    }

    @Override
    public void applyFixture(long ticks, float partialTick, float previewPartialTick, CameraProfile profile, Position pos) {
        List<List<RenderFrame>> frames = this.frames.get();
        int size = frames.size();
        if (size <= 0) {
            return;
        }
        float tick = (float)ticks + previewPartialTick;
        int index = (int)((float)((int)tick) * ((Float)this.speed.get()).floatValue()) - (Integer)this.shift.get();
        previewPartialTick = tick % 1.0f;
        if (index < 0) {
            frames.get(0).get(0).apply(pos);
            return;
        }
        if (index >= size) {
            List<RenderFrame> lastTick = frames.get(size - 1);
            lastTick.get(lastTick.size() - 1).apply(pos);
            return;
        }
        List<RenderFrame> lastTick = index - 1 >= 0 ? frames.get(index - 1) : null;
        RenderFrame last = lastTick == null || lastTick.isEmpty() ? null : lastTick.get(lastTick.size() - 1);
        float lastPt = last == null ? 0.0f : last.pt - 1.0f;
        for (RenderFrame frame : frames.get(index)) {
            if (frame.pt > previewPartialTick && previewPartialTick >= lastPt) {
                frame.apply(pos);
                return;
            }
            last = frame;
            lastPt = frame.pt;
        }
        if (last != null) {
            last.apply(pos);
        }
    }

    public List<List<RenderFrame>> setupRecorded() {
        if (this.recorded.isEmpty()) {
            return null;
        }
        ArrayList<List<RenderFrame>> frames = new ArrayList<List<RenderFrame>>();
        ArrayList<RenderFrame> tick = new ArrayList<RenderFrame>();
        RenderFrame last = this.recorded.get(0);
        int lastTick = last.tick;
        for (RenderFrame frame : this.recorded) {
            if (frame.tick > lastTick) {
                frames.add(tick);
                while (lastTick + 1 < frame.tick) {
                    tick = new ArrayList();
                    tick.add(last.copy());
                    ++lastTick;
                    frames.add(tick);
                }
                lastTick = frame.tick;
                tick = new ArrayList();
            }
            tick.add(frame);
            last = frame;
        }
        if (!tick.isEmpty()) {
            frames.add(tick);
        }
        this.recorded.clear();
        return frames;
    }

    @Override
    public AbstractFixture create(long duration) {
        return new ManualFixture(duration);
    }

    @Override
    protected void breakDownFixture(AbstractFixture original, long offset) {
        super.breakDownFixture(original, offset);
        this.shift.set((Number)((int)((float)((Integer)this.shift.get()).intValue() - (float)offset * ((Float)this.speed.get()).floatValue())));
    }
}

