/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.fixtures;

import java.util.List;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.data.RenderFrame;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.fixtures.DollyFixture;
import mchorse.aperture.camera.fixtures.ManualFixture;
import mchorse.aperture.camera.fixtures.PathFixture;
import mchorse.aperture.camera.values.ValueKeyframeChannel;
import net.minecraft.entity.player.EntityPlayer;

public class KeyframeFixture
extends AbstractFixture {
    public final ValueKeyframeChannel x = new ValueKeyframeChannel("x");
    public final ValueKeyframeChannel y = new ValueKeyframeChannel("y");
    public final ValueKeyframeChannel z = new ValueKeyframeChannel("z");
    public final ValueKeyframeChannel yaw = new ValueKeyframeChannel("yaw");
    public final ValueKeyframeChannel pitch = new ValueKeyframeChannel("pitch");
    public final ValueKeyframeChannel roll = new ValueKeyframeChannel("roll");
    public final ValueKeyframeChannel fov = new ValueKeyframeChannel("fov");
    public final ValueKeyframeChannel distance = new ValueKeyframeChannel("distance");
    public ValueKeyframeChannel[] channels;

    public KeyframeFixture(long duration) {
        super(duration);
        for (ValueKeyframeChannel channel : this.channels = new ValueKeyframeChannel[]{this.x, this.y, this.z, this.yaw, this.pitch, this.roll, this.fov, this.distance}) {
            this.register(channel);
        }
    }

    @Override
    public void initiate() {
        for (ValueKeyframeChannel channel : this.channels) {
            channel.get().sort();
        }
    }

    @Override
    public void fromPlayer(EntityPlayer player) {
        Position pos = new Position(player);
        this.x.get().insert(0L, pos.point.x);
        this.y.get().insert(0L, pos.point.y);
        this.z.get().insert(0L, pos.point.z);
        this.yaw.get().insert(0L, (double)pos.angle.yaw);
        this.pitch.get().insert(0L, (double)pos.angle.pitch);
        this.roll.get().insert(0L, (double)pos.angle.roll);
        this.fov.get().insert(0L, (double)pos.angle.fov);
        this.distance.get().insert(0L, -0.05);
    }

    @Override
    public void applyFixture(long ticks, float partialTick, float previewPartialTick, CameraProfile profile, Position pos) {
        float t = (float)ticks + previewPartialTick;
        if (!this.x.get().isEmpty()) {
            pos.point.x = this.x.get().interpolate(t);
        }
        if (!this.y.get().isEmpty()) {
            pos.point.y = this.y.get().interpolate(t);
        }
        if (!this.z.get().isEmpty()) {
            pos.point.z = this.z.get().interpolate(t);
        }
        if (!this.yaw.get().isEmpty()) {
            pos.angle.yaw = (float)this.yaw.get().interpolate(t);
        }
        if (!this.pitch.get().isEmpty()) {
            pos.angle.pitch = (float)this.pitch.get().interpolate(t);
        }
        double x = pos.point.x;
        double y = pos.point.y;
        double z = pos.point.z;
        float yaw = pos.angle.yaw;
        float pitch = pos.angle.pitch;
        float distance = this.distance.get().isEmpty() ? 0.0f : (float)this.distance.get().interpolate(t) + 0.05f;
        y += (double)distance * Math.sin(Math.toRadians(pitch));
        distance = (float)((double)distance * Math.cos(Math.toRadians(pitch)));
        pos.point.x = x += Math.sin(Math.toRadians(yaw)) * (double)distance;
        pos.point.y = y;
        pos.point.z = z -= Math.cos(Math.toRadians(yaw)) * (double)distance;
        if (!this.roll.get().isEmpty()) {
            pos.angle.roll = (float)this.roll.get().interpolate(t);
        }
        if (!this.fov.get().isEmpty()) {
            pos.angle.fov = (float)this.fov.get().interpolate(t);
        }
    }

    @Override
    public AbstractFixture create(long duration) {
        return new KeyframeFixture(duration);
    }

    @Override
    public void copyByReplacing(AbstractFixture from) {
        if (from instanceof DollyFixture) {
            PathFixture path = new PathFixture(from.getDuration());
            path.copyByReplacing(from);
            this.copyByReplacing(path);
            return;
        }
        super.copyByReplacing(from);
        if (from instanceof PathFixture) {
            PathFixture path = (PathFixture)from;
            if (path.size() > 1) {
                KeyframeFixture kf = path.toKeyframe();
                this.modifiers.reset();
                this.copy(kf);
            }
        } else if (from instanceof ManualFixture) {
            ManualFixture fixture = (ManualFixture)from;
            List<List<RenderFrame>> ticks = fixture.frames.get();
            int c = ticks.size();
            for (int i = 0; i < c; ++i) {
                List<RenderFrame> frames = ticks.get(i);
                if (frames == null || frames.size() <= 0) continue;
                RenderFrame frame = frames.get(0);
                this.x.get().insert((long)i, frame.x);
                this.y.get().insert((long)i, frame.y);
                this.z.get().insert((long)i, frame.z);
                this.yaw.get().insert((long)i, (double)frame.yaw);
                this.pitch.get().insert((long)i, (double)frame.pitch);
                this.roll.get().insert((long)i, (double)frame.roll);
                this.fov.get().insert((long)i, (double)frame.fov);
            }
        }
    }

    @Override
    protected void breakDownFixture(AbstractFixture original, long offset) {
        super.breakDownFixture(original, offset);
        for (ValueKeyframeChannel channel : this.channels) {
            channel.get().moveX(-offset);
        }
    }
}

