/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.fixtures;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Angle;
import mchorse.aperture.camera.data.Point;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.fixtures.IdleFixture;
import mchorse.aperture.camera.fixtures.PathFixture;
import mchorse.aperture.camera.values.ValueInterpolation;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.utils.Interpolation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class DollyFixture
extends IdleFixture {
    public final ValueFloat distance = new ValueFloat("distance", 0.1f);
    public final ValueInterpolation interp = new ValueInterpolation("interp");
    public final ValueFloat yaw = new ValueFloat("yaw", 0.0f);
    public final ValueFloat pitch = new ValueFloat("pitch", 0.0f);

    public DollyFixture(long duration) {
        super(duration);
        this.register((Value)this.distance);
        this.register(this.interp);
        this.register((Value)this.yaw);
        this.register((Value)this.pitch);
    }

    @Override
    public void fromPlayer(EntityPlayer player) {
        super.fromPlayer(player);
        this.yaw.set((Number)Float.valueOf(this.position.get().angle.yaw));
        this.pitch.set((Number)Float.valueOf(this.position.get().angle.pitch));
    }

    @Override
    public void applyFixture(long ticks, float partialTicks, float previewPartialTick, CameraProfile profile, Position pos) {
        pos.copy(this.position.get());
        Interpolation interp = this.interp.get();
        Point point = this.position.get().point;
        double x = point.x;
        double y = point.y;
        double z = point.z;
        float degToPi = (float)Math.PI / 180;
        float yaw = ((Float)this.yaw.get()).floatValue();
        float pitch = ((Float)this.pitch.get()).floatValue();
        float cos = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sin = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cos2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float sin2 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        Vec3d look = new Vec3d((double)(sin * cos2), (double)sin2, (double)(cos * cos2)).func_72432_b().func_186678_a((double)((Float)this.distance.get()).floatValue());
        partialTicks = ((float)ticks + previewPartialTick) / (float)this.getDuration();
        x = interp.interpolate(x, x + look.field_72450_a, (double)partialTicks);
        y = interp.interpolate(y, y + look.field_72448_b, (double)partialTicks);
        z = interp.interpolate(z, z + look.field_72449_c, (double)partialTicks);
        pos.point.set(x, y, z);
    }

    @Override
    public AbstractFixture create(long duration) {
        return new DollyFixture(duration);
    }

    @Override
    public void copyByReplacing(AbstractFixture from) {
        super.copyByReplacing(from);
        if (from instanceof PathFixture) {
            PathFixture path = (PathFixture)from;
            if (path.size() != 2) {
                return;
            }
            Position a = path.getPoint(0);
            Position b = path.getPoint(1);
            Angle angle = Angle.angle(b.point, a.point);
            this.distance.set((Number)Float.valueOf((float)a.point.length(b.point)));
            this.position.get().copy(a);
            this.yaw.set((Number)Float.valueOf(angle.yaw));
            this.pitch.set((Number)Float.valueOf(angle.pitch));
            Interpolation function = path.interpolation.get().function;
            if (function != null) {
                this.interp.set(function);
            }
        }
    }

    @Override
    protected void breakDownFixture(AbstractFixture original, long offset) {
        super.breakDownFixture(original, offset);
        DollyFixture dolly = (DollyFixture)original;
        Position position = new Position();
        original.applyFixture(offset, 0.0f, 0.0f, null, position);
        Point point = dolly.position.get().point;
        double dx = point.x - position.point.x;
        double dy = point.y - position.point.y;
        double dz = point.z - position.point.z;
        float distance = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.position.set(position);
        this.distance.set((Number)Float.valueOf(((Float)dolly.distance.get()).floatValue() - distance));
        dolly.distance.set((Number)Float.valueOf(distance));
    }
}

