/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.fixtures;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Point;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.values.ValuePoint;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueFloat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;

public class CircularFixture
extends AbstractFixture {
    public final ValuePoint start = new ValuePoint("start", new Point(0.0, 0.0, 0.0));
    public final ValueFloat offset = new ValueFloat("offset", 0.0f);
    public final ValueFloat distance = new ValueFloat("distance", 5.0f);
    public final ValueFloat circles = new ValueFloat("circles", 360.0f);
    public final ValueFloat pitch = new ValueFloat("pitch", 0.0f);

    public CircularFixture(long duration) {
        super(duration);
        this.register(this.start);
        this.register((Value)this.offset);
        this.register((Value)this.distance);
        this.register((Value)this.circles);
        this.register((Value)this.pitch);
    }

    @Override
    public void fromPlayer(EntityPlayer player) {
        this.start.get().set(player);
        this.pitch.set((Number)Float.valueOf(player.field_70125_A));
    }

    @Override
    public void applyFixture(long ticks, float partialTicks, float previewPartialTick, CameraProfile profile, Position pos) {
        float progress = (float)ticks / (float)this.getDuration() + 1.0f / (float)this.getDuration() * previewPartialTick;
        float angle = (float)(Math.toRadians(((Float)this.offset.get()).floatValue()) + (double)progress * Math.toRadians(((Float)this.circles.get()).floatValue()));
        float distance = ((Float)this.distance.get()).floatValue();
        double cos = (double)distance * Math.cos(angle);
        double sin = (double)distance * Math.sin(angle);
        Point point = this.start.get();
        double x = point.x + 0.5 + cos;
        double y = point.y;
        double z = point.z + 0.5 + sin;
        float yaw = (float)(MathHelper.func_181159_b((double)sin, (double)cos) * 57.29577951308232) - 90.0f;
        pos.point.set(x - 0.5, y, z - 0.5);
        pos.angle.set(MathHelper.func_76142_g((float)(yaw - 180.0f)), ((Float)this.pitch.get()).floatValue(), 0.0f, 70.0f);
    }

    @Override
    public AbstractFixture create(long duration) {
        return new CircularFixture(duration);
    }

    @Override
    protected void breakDownFixture(AbstractFixture original, long offset) {
        super.breakDownFixture(original, offset);
        CircularFixture circular = (CircularFixture)original;
        float newCircles = ((Float)circular.circles.get()).floatValue() * ((float)offset / (float)original.getDuration());
        this.offset.set((Number)Float.valueOf(((Float)circular.offset.get()).floatValue() + newCircles));
        this.circles.set((Number)Float.valueOf(((Float)circular.circles.get()).floatValue() - newCircles));
        circular.circles.set((Number)Float.valueOf(newCircles));
    }
}

