/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.fixtures;

import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.data.StructureBase;
import mchorse.aperture.camera.values.ValueModifiers;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.config.values.ValueLong;
import mchorse.mclib.config.values.ValueString;
import mchorse.mclib.network.IByteBufSerializable;
import net.minecraft.entity.player.EntityPlayer;

public abstract class AbstractFixture
extends StructureBase
implements IByteBufSerializable {
    public final ValueString name = new ValueString("name", "");
    public final ValueInt color = new ValueInt("color", 0);
    public final ValueLong duration = new ValueLong("duration", 1L, 1L, Long.MAX_VALUE);
    public final ValueModifiers modifiers = new ValueModifiers("modifiers");

    public AbstractFixture(long duration) {
        this.setDuration(duration);
        this.register((Value)this.name);
        this.register((Value)this.color);
        this.register((Value)this.duration);
        this.register(this.modifiers);
    }

    public void initiate() {
    }

    public void setDuration(long duration) {
        this.duration.set((Number)duration);
    }

    public long getDuration() {
        return (Long)this.duration.get();
    }

    public void fromPlayer(EntityPlayer player) {
    }

    public void applyFixture(long ticks, float partialTick, CameraProfile profile, Position pos) {
        this.applyFixture(ticks, partialTick, partialTick, profile, pos);
    }

    public abstract void applyFixture(long var1, float var3, float var4, CameraProfile var5, Position var6);

    public void applyFixture(double range, float partialTick, CameraProfile profile, Position pos) {
        long ticks = (long)(range * (double)this.getDuration());
        this.applyFixture(ticks, partialTick, profile, pos);
    }

    public void applyLast(CameraProfile profile, Position pos) {
        this.applyFixture(this.getDuration(), 0.0f, profile, pos);
    }

    public final AbstractFixture copy() {
        AbstractFixture fixture = this.create(this.getDuration());
        fixture.copy(this);
        return fixture;
    }

    public abstract AbstractFixture create(long var1);

    public void copyByReplacing(AbstractFixture from) {
        this.copy(from);
        this.setDuration(from.getDuration());
    }

    public AbstractFixture breakDown(long offset) {
        long duration = this.getDuration();
        if (offset <= 0L || offset >= duration) {
            return null;
        }
        AbstractFixture fixture = this.copy();
        fixture.setDuration(duration - offset);
        for (int i = 0; i < fixture.modifiers.size(); ++i) {
            fixture.modifiers.get(i).breakDown(this.modifiers.get(i), offset, duration);
        }
        fixture.breakDownFixture(this, offset);
        return fixture;
    }

    protected void breakDownFixture(AbstractFixture original, long offset) {
    }
}

