/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.destination;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import mchorse.aperture.Aperture;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.CameraUtils;
import mchorse.aperture.camera.destination.AbstractDestination;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;

public class ClientDestination
extends AbstractDestination {
    public ClientDestination(String filename) {
        super(filename);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof ClientDestination;
    }

    @Override
    public void rename(String name) {
        File to;
        File from = new File(ClientProxy.getClientCameras(), this.filename + ".json");
        if (from.renameTo(to = new File(ClientProxy.getClientCameras(), name + ".json"))) {
            ClientProxy.getCameraEditor().profiles.rename(this, name);
        }
    }

    @Override
    public void save(CameraProfile profile) {
        try {
            FileUtils.write((File)new File(ClientProxy.getClientCameras(), this.filename + ".json"), (CharSequence)CameraUtils.toJSON(profile), (Charset)StandardCharsets.UTF_8);
            Aperture.l10n.success((ICommandSender)Minecraft.func_71410_x().field_71439_g, "profile.client_save", new Object[]{this.filename});
        }
        catch (Exception e) {
            Aperture.l10n.error((ICommandSender)Minecraft.func_71410_x().field_71439_g, "profile.client_cant_save", new Object[]{this.filename});
        }
    }

    @Override
    public void load() {
        try {
            String json = FileUtils.readFileToString((File)new File(ClientProxy.getClientCameras(), this.filename + ".json"), (Charset)StandardCharsets.UTF_8);
            CameraProfile newProfile = CameraUtils.readProfileFromJSON(json);
            newProfile.setDestination(this);
            newProfile.dirty = false;
            ClientProxy.getCameraEditor().profiles.addProfile(newProfile);
            Aperture.l10n.success((ICommandSender)Minecraft.func_71410_x().field_71439_g, "profile.client_load", new Object[]{this.filename});
        }
        catch (Exception e) {
            Aperture.l10n.error((ICommandSender)Minecraft.func_71410_x().field_71439_g, "profile.client_cant_load", new Object[]{this.filename});
        }
    }

    @Override
    public void remove() {
        new File(ClientProxy.getClientCameras(), this.filename + ".json").delete();
    }

    @Override
    public ResourceLocation toResourceLocation() {
        return RLUtils.create((String)"client", (String)this.filename);
    }
}

