/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.destination;

import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.destination.ClientDestination;
import mchorse.aperture.camera.destination.ServerDestination;
import mchorse.mclib.utils.OpHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractDestination {
    protected String filename;

    public static AbstractDestination fromResourceLocation(ResourceLocation resource) {
        if (resource.func_110624_b().equals("client")) {
            return new ClientDestination(resource.func_110623_a());
        }
        return new ServerDestination(resource.func_110623_a());
    }

    @SideOnly(value=Side.CLIENT)
    public static AbstractDestination create(String filename) {
        return ClientProxy.server && OpHelper.isPlayerOp() ? new ServerDestination(filename) : new ClientDestination(filename);
    }

    public AbstractDestination(String filename) {
        this.setFilename(filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractDestination) {
            return this.filename.equals(((AbstractDestination)obj).getFilename());
        }
        return super.equals(obj);
    }

    public abstract void rename(String var1);

    public abstract void save(CameraProfile var1);

    public abstract void load();

    public abstract void remove();

    public abstract ResourceLocation toResourceLocation();
}

