/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.client.gui.panels.GuiManualFixturePanel;
import mchorse.aperture.utils.OptifineHelper;
import mchorse.mclib.utils.ICopy;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenderFrame
implements ICopy<RenderFrame> {
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float pitch;
    public float roll;
    public float fov;
    public float pt;
    public int tick;

    public RenderFrame() {
    }

    @SideOnly(value=Side.CLIENT)
    public RenderFrame(EntityPlayer player, float partialTicks) {
        this.fromPlayer(player, partialTicks);
    }

    public void position(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void angle(float yaw, float pitch, float roll, float fov) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
        this.fov = fov;
    }

    public void apply(Position pos) {
        pos.point.set(this.x, this.y, this.z);
        pos.angle.set(this.yaw, this.pitch, this.roll, this.fov);
    }

    @SideOnly(value=Side.CLIENT)
    public void fromPlayer(EntityPlayer player, float partialTicks) {
        this.x = Interpolations.lerp((double)player.field_70169_q, (double)player.field_70165_t, (double)partialTicks);
        this.y = Interpolations.lerp((double)player.field_70167_r, (double)player.field_70163_u, (double)partialTicks);
        this.z = Interpolations.lerp((double)player.field_70166_s, (double)player.field_70161_v, (double)partialTicks);
        this.yaw = player.field_70177_z;
        this.pitch = player.field_70125_A;
        this.roll = ClientProxy.control.roll;
        this.fov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
        this.pt = partialTicks;
        this.tick = GuiManualFixturePanel.tick;
        if (OptifineHelper.isZooming()) {
            this.fov *= 0.25f;
        }
    }

    public RenderFrame copy() {
        RenderFrame frame = new RenderFrame();
        frame.copy(this);
        return frame;
    }

    public void copy(RenderFrame origin) {
        this.position(origin.x, origin.y, origin.z);
        this.angle(origin.yaw, origin.pitch, origin.roll, origin.fov);
        this.pt = origin.pt;
    }

    public void fromJSON(JsonElement element) {
        if (element.isJsonArray() && element.getAsJsonArray().size() >= 8) {
            JsonArray array = element.getAsJsonArray();
            this.x = array.get(0).getAsDouble();
            this.y = array.get(1).getAsDouble();
            this.z = array.get(2).getAsDouble();
            this.yaw = array.get(3).getAsFloat();
            this.pitch = array.get(4).getAsFloat();
            this.roll = array.get(5).getAsFloat();
            this.fov = array.get(6).getAsFloat();
            this.pt = array.get(7).getAsFloat();
        } else if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            this.x = object.get("x").getAsDouble();
            this.y = object.get("y").getAsDouble();
            this.z = object.get("z").getAsDouble();
            this.yaw = object.get("yaw").getAsFloat();
            this.pitch = object.get("pitch").getAsFloat();
            this.roll = object.get("roll").getAsFloat();
            this.fov = object.get("fov").getAsFloat();
            this.pt = object.get("pt").getAsFloat();
        }
    }

    public JsonArray toJSON() {
        JsonArray array = new JsonArray();
        array.add((Number)this.x);
        array.add((Number)this.y);
        array.add((Number)this.z);
        array.add((Number)Float.valueOf(this.yaw));
        array.add((Number)Float.valueOf(this.pitch));
        array.add((Number)Float.valueOf(this.roll));
        array.add((Number)Float.valueOf(this.fov));
        array.add((Number)Float.valueOf(this.pt));
        return array;
    }
}

