/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.data;

import com.google.common.base.MoreObjects;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import mchorse.aperture.camera.data.Angle;
import mchorse.aperture.camera.data.Point;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.entity.player.EntityPlayer;

public class Position {
    public static final Position ZERO = new Position(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public Point point = new Point(0.0, 0.0, 0.0);
    public Angle angle = new Angle(0.0f, 0.0f);

    public static Position fromBytes(ByteBuf buffer) {
        return new Position(Point.fromBytes(buffer), Angle.fromBytes(buffer));
    }

    public Position() {
    }

    public Position(Point point, Angle angle) {
        this.point = point;
        this.angle = angle;
    }

    public Position(float x, float y, float z, float yaw, float pitch) {
        this.point.set(x, y, z);
        this.angle.set(yaw, pitch);
    }

    public Position(float x, float y, float z, float yaw, float pitch, float roll, float fov) {
        this.point.set(x, y, z);
        this.angle.set(yaw, pitch, roll, fov);
    }

    public Position(EntityPlayer player) {
        this.set(player);
    }

    public void set(Position position) {
        this.point.set(position.point);
        this.angle.set(position.angle);
    }

    public void set(EntityPlayer player) {
        this.point.set(player);
        this.angle.set(player);
    }

    public void copy(Position position) {
        this.point.set(position.point.x, position.point.y, position.point.z);
        this.angle.set(position.angle.yaw, position.angle.pitch, position.angle.roll, position.angle.fov);
    }

    public void apply(EntityPlayer player) {
        player.func_70080_a(this.point.x, Math.max(this.point.y - (double)player.func_70047_e(), -64.0), this.point.z, this.angle.yaw, this.angle.pitch);
        player.func_70012_b(this.point.x, Math.max(this.point.y - (double)player.func_70047_e(), -64.0), this.point.z, this.angle.yaw, this.angle.pitch);
        player.field_70179_y = 0.0;
        player.field_70181_x = 0.0;
        player.field_70159_w = 0.0;
        player.field_70759_as = player.field_70758_at = this.angle.yaw;
    }

    public void interpolate(Position position, float factor) {
        this.point.x = Interpolations.lerp((double)this.point.x, (double)position.point.x, (double)factor);
        this.point.y = Interpolations.lerp((double)this.point.y, (double)position.point.y, (double)factor);
        this.point.z = Interpolations.lerp((double)this.point.z, (double)position.point.z, (double)factor);
        this.angle.yaw = Interpolations.lerpYaw((float)this.angle.yaw, (float)position.angle.yaw, (float)factor);
        this.angle.pitch = Interpolations.lerp((float)this.angle.pitch, (float)position.angle.pitch, (float)factor);
        this.angle.roll = Interpolations.lerp((float)this.angle.roll, (float)position.angle.roll, (float)factor);
        this.angle.fov = Interpolations.lerp((float)this.angle.fov, (float)position.angle.fov, (float)factor);
    }

    public void fromJSON(JsonObject element) {
        if (element.has("point") && element.get("point").isJsonObject() && element.has("angle") && element.get("angle").isJsonObject()) {
            this.point.fromJSON(element.get("point").getAsJsonObject());
            this.angle.fromJSON(element.get("angle").getAsJsonObject());
        }
    }

    public JsonObject toJSON() {
        JsonObject object = new JsonObject();
        object.add("point", (JsonElement)this.point.toJSON());
        object.add("angle", (JsonElement)this.angle.toJSON());
        return object;
    }

    public void toBytes(ByteBuf buffer) {
        this.point.toBytes(buffer);
        this.angle.toBytes(buffer);
    }

    public Position copy() {
        return new Position(this.point.copy(), this.angle.copy());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Position) {
            Position position = (Position)obj;
            return this.angle.equals(position.angle) && this.point.equals(position.point);
        }
        return super.equals(obj);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.point).addValue((Object)this.angle).toString();
    }
}

