/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera.data;

import com.google.common.base.MoreObjects;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import mchorse.aperture.Aperture;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.data.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;

public class Angle {
    public float yaw;
    public float pitch;
    public float roll;
    public float fov = 70.0f;

    public static Angle fromBytes(ByteBuf buffer) {
        return new Angle(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public static Angle angle(Point a, Point b) {
        return Angle.angle(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static Angle angle(double dx, double dy, double dz) {
        double horizontalDistance = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        double yaw = MathHelper.func_181159_b((double)dz, (double)dx) * 180.0 / Math.PI - 90.0;
        double pitch = -(MathHelper.func_181159_b((double)dy, (double)horizontalDistance) * 180.0 / Math.PI);
        return new Angle((float)yaw, (float)pitch);
    }

    public Angle(float yaw, float pitch, float roll, float fov) {
        this.set(yaw, pitch, roll, fov);
    }

    public Angle(float yaw, float pitch) {
        this.set(yaw, pitch);
    }

    public void set(Angle angle) {
        this.set(angle.yaw, angle.pitch, angle.roll, angle.fov);
    }

    public void set(float yaw, float pitch, float roll, float fov) {
        this.set(yaw, pitch);
        this.roll = roll;
        this.fov = fov;
    }

    public void set(float yaw, float pitch) {
        if (Aperture.smoothClampPitch != null && ((Boolean)Aperture.smoothClampPitch.get()).booleanValue()) {
            pitch = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f);
        }
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public void set(EntityPlayer player) {
        float fov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
        this.set(player.field_70177_z, player.field_70125_A, ClientProxy.control.roll, fov);
    }

    public void fromJSON(JsonObject element) {
        this.yaw = element.get("yaw").getAsFloat();
        this.pitch = element.get("pitch").getAsFloat();
        this.roll = element.get("roll").getAsFloat();
        this.fov = element.get("fov").getAsFloat();
    }

    public JsonObject toJSON() {
        JsonObject object = new JsonObject();
        object.addProperty("yaw", (Number)Float.valueOf(this.yaw));
        object.addProperty("pitch", (Number)Float.valueOf(this.pitch));
        object.addProperty("roll", (Number)Float.valueOf(this.roll));
        object.addProperty("fov", (Number)Float.valueOf(this.fov));
        return object;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeFloat(this.yaw);
        buffer.writeFloat(this.pitch);
        buffer.writeFloat(this.roll);
        buffer.writeFloat(this.fov);
    }

    public Angle copy() {
        return new Angle(this.yaw, this.pitch, this.roll, this.fov);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Angle) {
            Angle angle = (Angle)obj;
            return this.yaw == angle.yaw && this.pitch == angle.pitch && this.roll == angle.roll && this.fov == angle.fov;
        }
        return super.equals(obj);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.yaw).addValue(this.pitch).addValue(this.roll).addValue(this.fov).toString();
    }
}

