/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.mclib.utils.Color;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModifierRegistry {
    public static final BiMap<Class<? extends AbstractModifier>, Byte> CLASS_TO_ID = HashBiMap.create();
    public static final BiMap<String, Class<? extends AbstractModifier>> NAME_TO_CLASS = HashBiMap.create();
    @SideOnly(value=Side.CLIENT)
    public static Map<Class<? extends AbstractModifier>, ModifierInfo> CLIENT;
    private static byte NEXT_ID;

    public static byte getNextId() {
        return NEXT_ID;
    }

    public static byte getType(AbstractModifier modifier) {
        Byte type = (Byte)CLASS_TO_ID.get(modifier.getClass());
        return type == null ? (byte)-1 : (byte)type;
    }

    public static AbstractModifier fromType(byte type) throws Exception {
        Class clazz = (Class)CLASS_TO_ID.inverse().get((Object)type);
        if (clazz != null) {
            return (AbstractModifier)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        throw new Exception("Modifier with type '" + type + "' not exists!");
    }

    public static void register(String name, Class<? extends AbstractModifier> clazz) {
        if (CLASS_TO_ID.containsKey(clazz)) {
            return;
        }
        CLASS_TO_ID.put(clazz, (Object)NEXT_ID);
        NAME_TO_CLASS.put((Object)name, clazz);
        NEXT_ID = (byte)(NEXT_ID + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerClient(Class<? extends AbstractModifier> clazz, String title, Color color) {
        Byte type = (Byte)CLASS_TO_ID.get(clazz);
        if (type == null) {
            return;
        }
        CLIENT.put(clazz, new ModifierInfo(type, title, color));
    }

    static {
        NEXT_ID = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ModifierInfo {
        public byte type;
        public String title;
        public Color color;

        public ModifierInfo(byte type, String title, Color color) {
            this.type = type;
            this.title = title;
            this.color = color;
        }

        public String getTitle() {
            return I18n.func_135052_a((String)this.title, (Object[])new Object[0]);
        }
    }
}

