/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.mclib.utils.Color;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FixtureRegistry {
    public static final BiMap<Class<? extends AbstractFixture>, Byte> CLASS_TO_ID = HashBiMap.create();
    public static final BiMap<String, Class<? extends AbstractFixture>> NAME_TO_CLASS = HashBiMap.create();
    public static final Map<String, Byte> NAME_TO_ID = new HashMap<String, Byte>();
    @SideOnly(value=Side.CLIENT)
    public static Map<Class<? extends AbstractFixture>, FixtureInfo> CLIENT;
    private static byte NEXT_ID;

    public static byte getNextId() {
        return NEXT_ID;
    }

    @SideOnly(value=Side.CLIENT)
    public static FixtureInfo getInfo(byte type) {
        return CLIENT.get(CLASS_TO_ID.inverse().get((Object)type));
    }

    public static AbstractFixture fromType(byte type, long duration) throws Exception {
        Class clazz = (Class)CLASS_TO_ID.inverse().get((Object)type);
        if (clazz == null) {
            throw new Exception("Camera fixture by type '" + type + "' wasn't found!");
        }
        return (AbstractFixture)clazz.getConstructor(Long.TYPE).newInstance(duration);
    }

    public static void register(String name, Class<? extends AbstractFixture> clazz) {
        if (CLASS_TO_ID.containsKey(clazz)) {
            return;
        }
        CLASS_TO_ID.put(clazz, (Object)NEXT_ID);
        NAME_TO_ID.put(name, NEXT_ID);
        NAME_TO_CLASS.put((Object)name, clazz);
        NEXT_ID = (byte)(NEXT_ID + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerClient(Class<? extends AbstractFixture> clazz, String title, Color color) {
        Byte type = (Byte)CLASS_TO_ID.get(clazz);
        if (type == null) {
            return;
        }
        CLIENT.put(clazz, new FixtureInfo(type, title, color));
    }

    static {
        NEXT_ID = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static class FixtureInfo {
        public byte type;
        public String title;
        public Color color;

        public FixtureInfo(byte type, String title, Color color) {
            this.type = type;
            this.title = title;
            this.color = color;
        }
    }
}

