/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Scanner;
import mchorse.aperture.Aperture;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.capabilities.camera.Camera;
import mchorse.aperture.capabilities.camera.ICamera;
import mchorse.aperture.network.Dispatcher;
import mchorse.aperture.network.common.PacketCameraProfile;
import mchorse.aperture.network.common.PacketCameraState;
import mchorse.mclib.utils.JsonUtils;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.DimensionManager;

public class CameraUtils {
    public static File cameraFile(String filename) {
        File file = new File(DimensionManager.getCurrentSaveRootDirectory() + "/aperture/cameras");
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, filename + ".json");
    }

    public static String readCameraProfile(String filename) throws Exception {
        File file = CameraUtils.cameraFile(filename);
        DataInputStream stream = new DataInputStream(new FileInputStream(file));
        Scanner scanner = new Scanner((InputStream)stream, "UTF-8");
        String content = scanner.useDelimiter("\\A").next();
        scanner.close();
        return content;
    }

    public static void writeCameraProfile(String filename, String profile) throws IOException {
        PrintWriter printer = new PrintWriter(CameraUtils.cameraFile(filename));
        printer.print(profile);
        printer.close();
    }

    public static void sendProfileToPlayer(String filename, EntityPlayerMP player, boolean play, boolean force) {
        try {
            if (!force && CameraUtils.playerHasProfile(player, filename, play)) {
                return;
            }
            if (!CameraUtils.cameraFile(filename).isFile()) {
                Aperture.l10n.error((ICommandSender)player, "profile.cant_load", new Object[]{filename});
                return;
            }
            CameraProfile profile = CameraUtils.readProfile(filename);
            ICamera recording = Camera.get((EntityPlayer)player);
            recording.setCurrentProfile(filename);
            recording.setCurrentProfileTimestamp(System.currentTimeMillis());
            Dispatcher.sendTo(new PacketCameraProfile(filename, profile, play), player);
        }
        catch (Exception e) {
            e.printStackTrace();
            Aperture.l10n.error((ICommandSender)player, "profile.cant_load", new Object[]{filename});
        }
    }

    public static CameraProfile readProfile(String filename) throws Exception {
        return CameraUtils.readProfileFromJSON(CameraUtils.readCameraProfile(filename));
    }

    public static CameraProfile readProfileFromJSON(String json) throws Exception {
        CameraProfile profile = new CameraProfile(null);
        JsonElement element = new JsonParser().parse(json);
        if (!element.isJsonObject()) {
            return profile;
        }
        profile.fromJSON(element.getAsJsonObject());
        return profile;
    }

    private static boolean playerHasProfile(EntityPlayerMP player, String filename, boolean play) {
        boolean isNewer;
        ICamera recording = Camera.get((EntityPlayer)player);
        File profile = CameraUtils.cameraFile(filename);
        boolean hasSame = recording.currentProfile().equals(filename);
        boolean bl = isNewer = recording.currentProfileTimestamp() >= profile.lastModified();
        if (hasSame && isNewer) {
            if (play) {
                Dispatcher.sendTo(new PacketCameraState(filename, true), player);
            } else {
                Aperture.l10n.info((ICommandSender)player, "profile.loaded", new Object[]{filename});
            }
            return true;
        }
        return false;
    }

    public static boolean saveCameraProfile(String filename, String profile, EntityPlayerMP player) {
        try {
            CameraUtils.writeCameraProfile(filename, profile);
        }
        catch (IOException e) {
            e.printStackTrace();
            Aperture.l10n.error((ICommandSender)player, "profile.cant_save", new Object[]{filename});
            return false;
        }
        return true;
    }

    public static String toJSON(CameraProfile profile) {
        JsonObject object = new JsonObject();
        profile.toJSON(object);
        return JsonUtils.jsonToPretty((JsonElement)object);
    }

    public static boolean renameProfile(String from, String to) {
        File fromFile = CameraUtils.cameraFile(from);
        File toFile = CameraUtils.cameraFile(to);
        return fromFile.renameTo(toFile);
    }

    public static boolean removeProfile(String profile) {
        File file = CameraUtils.cameraFile(profile);
        return file.delete();
    }

    public static float parseAspectRation(String ratio, float old) {
        try {
            return Float.parseFloat(ratio);
        }
        catch (Exception e) {
            try {
                String[] strips = ratio.split(":");
                if (strips.length >= 2) {
                    return Float.parseFloat(strips[0]) / Float.parseFloat(strips[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return old;
        }
    }
}

