/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera;

import java.util.function.Supplier;
import mchorse.aperture.Aperture;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraOutside;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.data.Angle;
import mchorse.aperture.camera.data.Point;
import mchorse.aperture.camera.data.Position;
import mchorse.mclib.utils.EntityUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.GameType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CameraRunner {
    private Minecraft mc = Minecraft.func_71410_x();
    private boolean isRunning = false;
    private CameraProfile profile;
    private Position position = new Position(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public long ticks;
    public CameraOutside outside = new CameraOutside();
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public Supplier<Long> duration;
    public boolean skipUpdate = false;

    public boolean isRunning() {
        return this.isRunning;
    }

    public Position getPosition() {
        return this.position;
    }

    public void toggle(CameraProfile profile, long ticks) {
        this.toggle(profile, ticks, null);
    }

    public void toggle(CameraProfile profile, long ticks, Supplier<Long> duration) {
        if (this.isRunning) {
            this.stop();
        } else {
            this.start(profile, ticks, duration);
        }
    }

    public void start(CameraProfile profile) {
        this.start(profile, 0L);
    }

    public void start(CameraProfile profile, long ticks) {
        this.start(profile, ticks, null);
    }

    public void start(CameraProfile profile, long start, Supplier<Long> duration) {
        if (profile == null) {
            return;
        }
        this.profile = profile;
        if (!this.isRunning) {
            ClientProxy.control.cache();
            this.position.set((EntityPlayer)this.mc.field_71439_g);
            if (((Boolean)Aperture.spectator.get()).booleanValue() && !((Boolean)Aperture.outside.get()).booleanValue() && EntityUtils.getGameMode() != GameType.SPECTATOR) {
                this.mc.field_71439_g.func_71165_d("/gamemode 3");
            }
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.attachOutside();
        }
        this.position.set((EntityPlayer)this.mc.field_71439_g);
        this.isRunning = true;
        this.ticks = start;
        this.duration = duration;
        this.skipUpdate = true;
    }

    public void stop() {
        if (this.isRunning) {
            ClientProxy.control.restore();
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.detachOutside();
        }
        this.isRunning = false;
        this.profile = null;
        this.duration = null;
        this.skipUpdate = false;
        ClientProxy.control.resetRoll();
    }

    public void attachOutside() {
        if (!this.outside.active && ((Boolean)Aperture.outside.get()).booleanValue()) {
            this.outside.start();
        }
    }

    public void detachOutside() {
        if (this.outside.active) {
            this.outside.stop();
        }
    }

    public void setTick(long ticks) {
        this.ticks = ticks;
        this.skipUpdate = this.isRunning;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (this.profile == null || this.mc.field_71439_g == null) {
            this.stop();
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            if (this.outside.active) {
                this.mc.func_175607_a((Entity)((Boolean)Aperture.outsideSky.get() != false ? this.mc.field_71439_g : this.outside.camera));
            }
            return;
        }
        long profileDuration = this.profile.getDuration();
        long progress = this.ticks;
        long duration = this.duration == null ? profileDuration : this.duration.get();
        if (progress >= duration) {
            this.stop();
        } else {
            double dz;
            double dy;
            double dx;
            if (this.outside.active) {
                this.mc.func_175607_a((Entity)((Boolean)Aperture.outsideSky.get() != false ? this.outside.camera : this.mc.field_71439_g));
            }
            if (((Boolean)Aperture.debugTicks.get()).booleanValue()) {
                Aperture.LOGGER.info("Camera render frame: " + event.renderTickTime + " " + this.ticks);
            }
            double prevX = this.position.point.x;
            double prevY = this.position.point.y;
            double prevZ = this.position.point.z;
            this.profile.applyCurves(progress, event.renderTickTime);
            if (progress < profileDuration) {
                this.profile.applyProfile(progress, event.renderTickTime, this.position);
            }
            EntityPlayerSP player = this.mc.field_71439_g;
            Point point = this.position.point;
            Angle angle = this.position.angle;
            this.mc.field_71474_y.field_74334_X = angle.fov;
            ClientProxy.control.roll = angle.roll;
            double y = point.y + Math.sin(progress) * 1.0E-9 + 1.0E-9;
            this.setCameraPosition((EntityPlayer)player, point.x, y, point.z, angle);
            if (!this.outside.active) {
                player.field_70179_y = 0.0;
                player.field_70181_x = 0.0;
                player.field_70159_w = 0.0;
            }
            if (!this.mc.func_71356_B() && !this.outside.active && (dx = point.x - prevX) * dx + (dy = point.y - prevY) * dy + (dz = point.z - prevZ) * dz >= 100.0) {
                if (((Boolean)Aperture.essentialsTeleport.get()).booleanValue()) {
                    this.mc.field_71439_g.func_71165_d("/minecraft:tp " + point.x + " " + point.y + " " + point.z + " " + angle.yaw + " " + angle.pitch);
                } else {
                    this.mc.field_71439_g.func_71165_d("/tp " + point.x + " " + point.y + " " + point.z + " " + angle.yaw + " " + angle.pitch);
                }
            }
            this.yaw = angle.yaw;
            this.pitch = angle.pitch;
            if (player.func_70093_af()) {
                player.func_70095_a(false);
            }
        }
    }

    public void setCameraPosition(EntityPlayer player, double x, double y, double z, Angle angle) {
        EntityPlayer camera = this.outside.active ? this.outside.camera : player;
        camera.func_70012_b(x, Math.max(y - (double)camera.func_70047_e(), -64.0), z, angle.yaw % 360.0f, angle.pitch);
        camera.func_70080_a(x, Math.max(y - (double)camera.func_70047_e(), -64.0), z, angle.yaw % 360.0f, angle.pitch);
        camera.field_70759_as = camera.field_70758_at = angle.yaw;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT && event.player == this.mc.field_71439_g && event.phase == TickEvent.Phase.START) {
            if (((Boolean)Aperture.debugTicks.get()).booleanValue()) {
                Aperture.LOGGER.info("Camera frame: " + this.ticks);
            }
            if (this.skipUpdate) {
                this.skipUpdate = false;
            } else {
                ++this.ticks;
            }
        }
    }
}

