/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera;

import javax.vecmath.Vector2d;
import mchorse.aperture.Aperture;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.CameraRunner;
import mchorse.aperture.camera.FixtureRegistry;
import mchorse.aperture.camera.data.InterpolationType;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.fixtures.CircularFixture;
import mchorse.aperture.camera.fixtures.DollyFixture;
import mchorse.aperture.camera.fixtures.KeyframeFixture;
import mchorse.aperture.camera.fixtures.ManualFixture;
import mchorse.aperture.camera.fixtures.PathFixture;
import mchorse.aperture.camera.smooth.Filter;
import mchorse.aperture.camera.smooth.SmoothCamera;
import mchorse.aperture.client.KeyboardHandler;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.panels.GuiAbstractFixturePanel;
import mchorse.aperture.client.gui.panels.GuiManualFixturePanel;
import mchorse.aperture.utils.TimeUtils;
import mchorse.mclib.utils.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class CameraRenderer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("aperture", "textures/gui/fixture.png");
    protected Minecraft mc = Minecraft.func_71410_x();
    public SmoothCamera smooth = new SmoothCamera();
    public Filter roll = new Filter();
    public Filter fov = new Filter();
    protected double playerX;
    protected double playerY;
    protected double playerZ;
    private Position prev = new Position(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private Position next = new Position(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private Color color = new Color();

    public void toggleRender() {
        Aperture.profileRender.set((Object)((Boolean)Aperture.profileRender.get() == false ? 1 : 0));
        Aperture.profileRender.getConfig().save();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCameraOrient(EntityViewRenderEvent.CameraSetup event) {
        float roll;
        float playerYaw;
        CameraRunner runner = ClientProxy.runner;
        float ticks = (float)event.getRenderPartialTicks();
        EntityPlayerSP player = this.mc.field_71439_g;
        float f = playerYaw = runner.outside.active ? runner.outside.camera.field_70177_z : player.field_70177_z;
        if ((double)Math.abs(event.getYaw() - 180.0f - playerYaw) > 0.001) {
            return;
        }
        if (runner.isRunning()) {
            event.setYaw(-180.0f + runner.yaw);
            event.setPitch(runner.pitch);
            if (((Boolean)Aperture.outside.get()).booleanValue() && !((Boolean)Aperture.outsideHidePlayer.get()).booleanValue()) {
                this.mc.field_71474_y.field_74320_O = 1;
            }
        } else if (Minecraft.func_71410_x().field_71462_r instanceof GuiCameraEditor) {
            Position position = ClientProxy.getCameraEditor().position;
            event.setYaw(-180.0f + position.angle.yaw);
            event.setPitch(position.angle.pitch);
        } else if (((Boolean)this.smooth.enabled.get()).booleanValue() && !this.mc.func_147113_T()) {
            float yaw = this.smooth.getInterpYaw(ticks);
            float pitch = this.smooth.getInterpPitch(ticks);
            event.setYaw(-180.0f + yaw);
            event.setPitch(-pitch);
            player.field_70177_z = yaw;
            player.field_70125_A = -pitch;
            player.field_70126_B = yaw;
            player.field_70127_C = -pitch;
            if (this.roll.acc != 0.0f) {
                ClientProxy.control.roll = this.roll.interpolate(ticks);
            } else {
                this.roll.set(ClientProxy.control.roll);
            }
            if (this.fov.acc != 0.0f) {
                this.fov.interpolate(ticks);
                this.mc.field_71474_y.field_74334_X = this.fov.value = MathHelper.func_76131_a((float)this.fov.value, (float)1.0E-4f, (float)179.9999f);
            } else {
                this.fov.set(this.mc.field_71474_y.field_74334_X);
            }
        }
        if ((roll = ClientProxy.control.getRoll(ticks)) == 0.0f) {
            return;
        }
        event.setRoll(roll);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        SmoothCamera camera = ClientProxy.renderer.smooth;
        EntityPlayerSP player = this.mc.field_71439_g;
        if (event.side == Side.CLIENT && event.player == player) {
            if (((Boolean)camera.enabled.get()).booleanValue()) {
                float roll;
                float sensetivity = this.mc.field_71474_y.field_74341_c * 0.6f + 0.2f;
                float finalSensetivity = sensetivity * sensetivity * sensetivity * 8.0f;
                float dx = (float)this.mc.field_71417_B.field_74377_a * finalSensetivity * 0.15f;
                float dy = (float)this.mc.field_71417_B.field_74375_b * finalSensetivity * 0.15f;
                camera.update((EntityPlayer)this.mc.field_71439_g, dx, dy);
                KeyboardHandler keys = ClientProxy.keys;
                float f = keys.addRoll.func_151470_d() ? 1.0f : (roll = keys.reduceRoll.func_151470_d() ? -1.0f : 0.0f);
                float fov = keys.addFov.func_151470_d() ? 1.0f : (keys.reduceFov.func_151470_d() ? -1.0f : 0.0f);
                this.roll.accelerate(roll * ((Float)this.roll.factor.get()).floatValue());
                this.fov.accelerate(fov * ((Float)this.fov.factor.get()).floatValue());
            }
            if (event.phase == TickEvent.Phase.START) {
                GuiManualFixturePanel.update();
            }
        }
    }

    @SubscribeEvent
    public void onLastRender(RenderWorldLastEvent event) {
        boolean badProfile;
        int shader;
        GuiAbstractFixturePanel panel;
        if (GuiManualFixturePanel.recording && (panel = (GuiAbstractFixturePanel)ClientProxy.getCameraEditor().panel.delegate) instanceof GuiManualFixturePanel) {
            ((GuiManualFixturePanel)panel).recordFrame(this.mc.field_71439_g, event.getPartialTicks());
        }
        if ((shader = GL11.glGetInteger((int)35725)) != 0) {
            OpenGlHelper.func_153161_d((int)0);
        }
        CameraProfile profile = ClientProxy.control.currentProfile;
        CameraRunner runner = ClientProxy.runner;
        boolean bl = badProfile = profile == null || profile.size() < 1;
        if (!((Boolean)Aperture.profileRender.get()).booleanValue()) {
            return;
        }
        if (runner.isRunning()) {
            return;
        }
        if (badProfile) {
            return;
        }
        EntityPlayer player = runner.outside.active ? runner.outside.camera : this.mc.field_71439_g;
        float ticks = event.getPartialTicks();
        this.playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)ticks;
        this.playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)ticks;
        this.playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)ticks;
        GlStateManager.func_179123_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GL11.glLineWidth((float)4.0f);
        for (int i = 0; i < profile.fixtures.size(); ++i) {
            AbstractFixture fixture = profile.fixtures.get(i);
            if (fixture instanceof PathFixture) {
                ((PathFixture)fixture).disableSpeed();
            }
            fixture.applyFixture(0L, 0.0f, profile, this.prev);
            fixture.applyFixture(fixture.getDuration(), 0.0f, profile, this.next);
            long duration = fixture.getDuration();
            double distX = Math.abs(this.next.point.x - this.prev.point.x);
            double distY = Math.abs(this.next.point.y - this.prev.point.y);
            double distZ = Math.abs(this.next.point.z - this.prev.point.z);
            this.color.set(((Integer)fixture.color.get()).intValue(), false);
            if (this.color.getRGBColor() == 0) {
                this.color.copy(FixtureRegistry.CLIENT.get(fixture.getClass()).color);
            }
            if (distX + distY + distZ >= 0.5) {
                this.drawCard(this.color, i, duration, this.next);
            }
            this.drawCard(this.color, i, duration, this.prev);
            this.drawFixture(this.color, fixture, this.prev, this.next);
            if (!(fixture instanceof PathFixture)) continue;
            ((PathFixture)fixture).reenableSpeed();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179099_b();
        if (shader != 0) {
            OpenGlHelper.func_153161_d((int)shader);
        }
    }

    private void drawFixture(Color color, AbstractFixture fixture, Position prev, Position next) {
        if (fixture instanceof PathFixture || fixture instanceof KeyframeFixture || fixture instanceof DollyFixture || fixture instanceof ManualFixture) {
            this.drawPathFixture(color, fixture, prev, next);
        } else if (fixture instanceof CircularFixture) {
            this.drawCircularFixture(color, fixture, prev, next);
        }
    }

    private void drawPathFixture(Color color, AbstractFixture fixture, Position prev, Position next) {
        int i;
        CameraProfile profile = ClientProxy.control.currentProfile;
        long duration = fixture.getDuration();
        int size = (int)(duration / 5L);
        PathFixture path = null;
        if (fixture instanceof PathFixture) {
            path = (PathFixture)fixture;
            size = path.size();
        }
        int p = 15;
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179090_x();
        builder.func_178969_c(-this.playerX, -this.playerY, -this.playerZ);
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (fixture instanceof DollyFixture) {
            builder.func_181662_b(prev.point.x, prev.point.y, prev.point.z).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            builder.func_181662_b(next.point.x, next.point.y, next.point.z).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
        } else {
            for (i = 0; i < size; ++i) {
                for (int j = 0; j < 15; ++j) {
                    fixture.applyFixture((long)((float)(j + i * 15) / (float)(size * 15) * (float)duration), 0.0f, profile, prev);
                    fixture.applyFixture((long)((float)(j + i * 15 + 1) / (float)(size * 15) * (float)duration), 0.0f, profile, next);
                    builder.func_181662_b(prev.point.x, prev.point.y, prev.point.z).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
                    builder.func_181662_b(next.point.x, next.point.y, next.point.z).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
                }
            }
        }
        Tessellator.func_178181_a().func_78381_a();
        if (path != null && path.interpolation.get() == InterpolationType.CIRCULAR && path.size() > 0) {
            Vector2d center = path.getCenter();
            double y = 0.0;
            for (int i2 = 0; i2 < path.size(); ++i2) {
                y += path.points.get((int)i2).point.y;
            }
            GL11.glPointSize((float)10.0f);
            builder.func_181668_a(0, DefaultVertexFormats.field_181706_f);
            builder.func_181662_b(center.x, y /= (double)path.size(), center.y).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            builder.func_181662_b(center.x, y, center.y).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPointSize((float)8.0f);
            builder.func_181668_a(0, DefaultVertexFormats.field_181706_f);
            builder.func_181662_b(center.x, y, center.y).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            builder.func_181662_b(center.x, y, center.y).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        builder.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179098_w();
        if (path != null) {
            for (i = 1; i < path.size() - 1; ++i) {
                fixture.applyFixture(path.getTickForPoint(i), 0.0f, profile, prev);
                this.drawPathPoint(color, prev, i);
            }
        }
    }

    private void drawPathPoint(Color color, Position position, int index) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71446_o.func_110577_a(TEXTURE);
        double x = position.point.x - this.playerX;
        double y = position.point.y - this.playerY;
        double z = position.point.z - this.playerZ;
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiCameraEditor) {
            Position pos = ClientProxy.getCameraEditor().position;
            GlStateManager.func_179114_b((float)(-pos.angle.yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)pos.angle.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)(-this.mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.mc.func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float factor = 0.1f;
        float minX = -factor;
        float minY = -factor;
        float maxX = factor;
        float maxY = factor;
        int tw = 34;
        int tx = 32;
        int tx2 = 34;
        float texX = (float)tx / (float)tw;
        float texY = 0.0f;
        float texRX = (float)tx2 / (float)tw;
        float texRY = 0.125f;
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)minX, (double)minY, 0.0).func_187315_a((double)texRX, (double)texRY).func_181675_d();
        vb.func_181662_b((double)minX, (double)maxY, 0.0).func_187315_a((double)texRX, (double)texY).func_181675_d();
        vb.func_181662_b((double)maxX, (double)maxY, 0.0).func_187315_a((double)texX, (double)texY).func_181675_d();
        vb.func_181662_b((double)maxX, (double)minY, 0.0).func_187315_a((double)texX, (double)texRY).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179084_k();
        String indexString = String.valueOf(index);
        int indexWidth = this.mc.field_71466_p.func_78256_a(indexString) / 2;
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.03f, (float)0.03f, (float)0.03f);
        GlStateManager.func_179137_b((double)0.0, (double)-3.5, (double)-0.1);
        GlStateManager.func_179109_b((float)0.0f, (float)-12.0f, (float)0.0f);
        this.mc.field_71466_p.func_78276_b(indexString, -indexWidth, 0, -1);
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawCircularFixture(Color color, AbstractFixture fixture, Position prev, Position next) {
        CameraProfile profile = ClientProxy.control.currentProfile;
        float circles = Math.min(((Float)((CircularFixture)fixture).circles.get()).floatValue(), 360.0f);
        long duration = fixture.getDuration();
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179090_x();
        vb.func_178969_c(-this.playerX, -this.playerY, -this.playerZ);
        vb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        int i = 0;
        while ((float)i < circles) {
            float a = (float)i / circles * (float)duration;
            float b = (float)(i + 3) / circles * (float)duration;
            fixture.applyFixture((long)a, a - (float)((int)a), profile, prev);
            fixture.applyFixture((long)b, b - (float)((int)b), profile, next);
            if (i == 0) {
                vb.func_181662_b(prev.point.x, prev.point.y, prev.point.z).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            }
            vb.func_181662_b(next.point.x, next.point.y, next.point.z).func_181666_a(color.r, color.g, color.b, 1.0f).func_181675_d();
            i += 5;
        }
        Tessellator.func_178181_a().func_78381_a();
        vb.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179098_w();
    }

    private void drawCard(Color color, int index, long duration, Position pos) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)color.r, (float)color.g, (float)color.b, (float)0.8f);
        this.mc.field_71446_o.func_110577_a(TEXTURE);
        double x = pos.point.x - this.playerX;
        double y = pos.point.y - this.playerY;
        double z = pos.point.z - this.playerZ;
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiCameraEditor) {
            Position position = ClientProxy.getCameraEditor().position;
            GlStateManager.func_179114_b((float)(-position.angle.yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)position.angle.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)(-this.mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.mc.func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float factor = 0.5f;
        float minX = -factor;
        float minY = -factor;
        float maxX = factor;
        float maxY = factor;
        int tw = 34;
        int i = 0;
        int tx = i * 16;
        int tx2 = tx + 16;
        float texX = (float)tx / (float)tw;
        float texY = 0.0f;
        float texRX = (float)tx2 / (float)tw;
        float texRY = 1.0f;
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)minX, (double)minY, 0.0).func_187315_a((double)texRX, (double)texRY).func_181675_d();
        vb.func_181662_b((double)minX, (double)maxY, 0.0).func_187315_a((double)texRX, (double)texY).func_181675_d();
        vb.func_181662_b((double)maxX, (double)maxY, 0.0).func_187315_a((double)texX, (double)texY).func_181675_d();
        vb.func_181662_b((double)maxX, (double)minY, 0.0).func_187315_a((double)texX, (double)texRY).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179084_k();
        String indexString = String.valueOf(index);
        String durationString = TimeUtils.formatTime(duration) + ((Boolean)Aperture.editorSeconds.get() != false ? "s" : "t");
        int indexWidth = this.mc.field_71466_p.func_78256_a(indexString) / 2;
        int durationWidth = this.mc.field_71466_p.func_78256_a(durationString) / 2;
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.05f, (float)0.05f, (float)0.05f);
        GlStateManager.func_179137_b((double)0.0, (double)-3.5, (double)-0.1);
        this.mc.field_71466_p.func_78276_b(indexString, -indexWidth, 0, -1);
        GlStateManager.func_179109_b((float)0.0f, (float)-13.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        this.mc.field_71466_p.func_78276_b(durationString, -durationWidth, 0, -1);
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

