/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.data.Position;
import mchorse.aperture.camera.data.StructureBase;
import mchorse.aperture.camera.destination.AbstractDestination;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.values.ValueCurves;
import mchorse.aperture.camera.values.ValueFixtures;
import mchorse.aperture.camera.values.ValueModifiers;
import mchorse.aperture.events.CameraProfileChangedEvent;
import mchorse.mclib.utils.undo.UndoManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CameraProfile
extends StructureBase {
    public static final Pattern NUMBERED_SUFFIX = Pattern.compile("_(\\d+)$");
    public final ValueCurves curves = new ValueCurves("curves");
    public final ValueModifiers modifiers = new ValueModifiers("modifiers");
    public final ValueFixtures fixtures = new ValueFixtures("fixtures");
    protected AbstractDestination destination;
    public boolean dirty;
    public boolean exists = true;
    public UndoManager<CameraProfile> undoManager = new UndoManager(30);

    public CameraProfile(AbstractDestination destination) {
        this.destination = destination;
        this.register(this.curves);
        this.register(this.modifiers);
        this.register(this.fixtures);
    }

    public AbstractDestination getDestination() {
        return this.destination;
    }

    public void setDestination(AbstractDestination destination) {
        this.destination = destination;
        this.dirty();
    }

    public long getDuration() {
        long duration = 0L;
        for (int i = 0; i < this.fixtures.size(); ++i) {
            duration += this.fixtures.get(i).getDuration();
        }
        return duration;
    }

    public void initiate() {
        for (int i = 0; i < this.fixtures.size(); ++i) {
            this.fixtures.get(i).initiate();
        }
    }

    public void dirty() {
        this.setDirty(true);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        MinecraftForge.EVENT_BUS.post((Event)new CameraProfileChangedEvent(this));
    }

    public long calculateOffset(AbstractFixture target) {
        AbstractFixture fixture;
        long tick = 0L;
        for (int i = 0; i < this.fixtures.size() && (fixture = this.fixtures.get(i)) != target; ++i) {
            tick += fixture.getDuration();
        }
        return tick;
    }

    public long calculateOffset(long tick, boolean next) {
        long sum = 0L;
        for (int i = 0; i < this.fixtures.size(); ++i) {
            AbstractFixture fixture = this.fixtures.get(i);
            long duration = fixture.getDuration();
            if ((sum += duration) <= tick) continue;
            if (next) break;
            sum -= duration;
            break;
        }
        return sum;
    }

    public AbstractFixture atTick(long tick) {
        if (tick >= this.getDuration() || tick < 0L) {
            return null;
        }
        long pos = 0L;
        AbstractFixture out = null;
        for (int i = 0; i < this.fixtures.size(); ++i) {
            AbstractFixture fixture = this.fixtures.get(i);
            if (tick < pos) break;
            pos += fixture.getDuration();
            out = fixture;
        }
        return out;
    }

    public int size() {
        return this.fixtures.size();
    }

    public AbstractFixture get(int index) {
        return this.has(index) ? this.fixtures.get(index) : null;
    }

    public boolean has(int index) {
        return index >= 0 && index < this.size();
    }

    public void add(AbstractFixture fixture) {
        this.fixtures.add(fixture);
        this.dirty();
    }

    public void add(AbstractFixture fixture, int index) {
        if (index < this.size()) {
            this.fixtures.add(index, fixture);
        } else {
            this.fixtures.add(fixture);
        }
        this.dirty();
    }

    public void remove(int index) {
        int size = this.size();
        if (index >= 0 && index < size) {
            this.fixtures.remove(index);
            this.dirty();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void applyCurves(long progress, float partialTick) {
        ClientProxy.curveManager.applyCurves(this.curves, progress, partialTick);
    }

    public void applyProfile(long progress, float partialTick, Position position) {
        this.applyProfile(progress, partialTick, partialTick, position);
    }

    public void applyProfile(long progress, float partialTick, float previewPartialTick, Position position) {
        this.applyProfile(progress, partialTick, previewPartialTick, position, true, null);
    }

    public void applyProfile(long progress, float partialTick, Position position, boolean modifiers) {
        this.applyProfile(progress, partialTick, partialTick, position, modifiers, null);
    }

    public void applyProfile(long progress, float partialTick, float previewPartialTick, Position position, boolean modifiers, AbstractModifier target) {
        AbstractFixture fixture;
        long duration;
        int index = 0;
        long originalProgress = progress;
        for (int i = 0; i < this.fixtures.size() && progress >= (duration = (fixture = this.fixtures.get(i)).getDuration()); ++i) {
            progress -= duration;
            ++index;
        }
        if (index >= this.size()) {
            if (index == 0) {
                return;
            }
            index = this.size() - 1;
            progress = this.fixtures.get(index).getDuration();
        }
        AbstractFixture fixture2 = this.fixtures.get(index);
        fixture2.applyFixture(progress, partialTick, previewPartialTick, this, position);
        if (modifiers && AbstractModifier.applyModifiers(this, fixture2, originalProgress, progress, partialTick, previewPartialTick, target, position)) {
            AbstractModifier.applyModifiers(this, null, originalProgress, originalProgress, partialTick, previewPartialTick, target, position);
        }
    }

    public void save() {
        this.exists = true;
        if (this.destination != null) {
            this.destination.save(this);
        }
        this.setDirty(false);
    }

    public CameraProfile copy() {
        ResourceLocation path = this.destination.toResourceLocation();
        String filename = path.func_110623_a();
        Matcher matcher = NUMBERED_SUFFIX.matcher(filename);
        filename = matcher.find() ? filename.substring(0, matcher.start()) + "_" + (Integer.parseInt(matcher.group(1)) + 1) : filename + "_1";
        AbstractDestination dest = AbstractDestination.fromResourceLocation(new ResourceLocation(path.func_110624_b(), filename));
        CameraProfile profile = new CameraProfile(dest);
        profile.copy(this);
        profile.initiate();
        return profile;
    }

    public void copyFrom(CameraProfile profile) {
        this.exists = true;
        this.fixtures.copy(profile.fixtures);
        this.modifiers.copy(profile.modifiers);
        this.curves.copy(profile.curves);
    }
}

