/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import info.ata4.minecraft.minema.CaptureSession;
import info.ata4.minecraft.minema.Minema;
import info.ata4.minecraft.minema.client.event.MinemaEventbus;
import info.ata4.minecraft.minema.client.modules.modifiers.TimerModifier;
import info.ata4.minecraft.minema.client.modules.video.vr.CubeFace;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import mchorse.aperture.camera.CameraRunner;
import mchorse.aperture.utils.EntitySelector;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MatrixUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class CameraExporter {
    private final DoubleBuffer buffer = BufferUtils.createDoubleBuffer((int)16);
    private final double[] doubles = new double[16];
    private final Matrix4d modelview = new Matrix4d();
    private final Matrix4d camera = new Matrix4d();
    private JsonObject wrapper = new JsonObject();
    private JsonArray cameraData = new JsonArray();
    private JsonObject entityData = new JsonObject();
    private JsonObject morphData = new JsonObject();
    private Map<String, TrackingPacket> registeredTrackingPackets = new HashMap<String, TrackingPacket>();
    private BiMap<String, String> entityNameRemaps = HashBiMap.create();
    private double[] trackingInitialPos = new double[]{0.0, 0.0, 0.0};
    private Set<Entity> entities = new HashSet<Entity>();
    private CameraRunner runner;
    private int frame;
    private int heldframes;
    private double motionblurFrames;
    private boolean building = false;
    private boolean trackedCamera = false;
    private boolean relativeOrigin = false;
    private String selector;

    public void setOriginX(double x) {
        this.trackingInitialPos[0] = x;
    }

    public void setOriginY(double y) {
        this.trackingInitialPos[1] = y;
    }

    public void setOriginZ(double z) {
        this.trackingInitialPos[2] = z;
    }

    public void setEntitiesSelector(String selector) {
        this.selector = selector;
    }

    public String getEntitiesSelector() {
        return this.selector;
    }

    public int getFrame() {
        return (int)Math.floor((double)this.frame / this.motionblurFrames);
    }

    public boolean isTracking() {
        return this.building;
    }

    public void setRelativeOrigin(boolean relativeOrigin) {
        this.relativeOrigin = relativeOrigin;
    }

    private void readMVP() {
        this.buffer.clear();
        GL11.glGetDouble((int)2982, (DoubleBuffer)this.buffer);
        this.buffer.get(this.doubles);
        this.modelview.set(this.doubles);
        this.modelview.transpose();
    }

    public void reset() {
        this.buffer.clear();
        for (int i = 0; i < this.doubles.length; ++i) {
            this.doubles[i] = 0.0;
        }
        this.modelview.setIdentity();
        this.camera.setIdentity();
        this.wrapper = new JsonObject();
        this.cameraData = new JsonArray();
        this.entityData = new JsonObject();
        this.morphData = new JsonObject();
        this.registeredTrackingPackets.forEach((key, value) -> ((TrackingPacket)value).reset());
        this.registeredTrackingPackets.clear();
        this.entityNameRemaps.clear();
        if (!this.relativeOrigin) {
            this.trackingInitialPos[0] = 0.0;
            this.trackingInitialPos[1] = 0.0;
            this.trackingInitialPos[2] = 0.0;
        }
        this.building = false;
        this.frame = 0;
        this.motionblurFrames = 0.0;
        this.heldframes = 0;
        this.runner = null;
        this.trackedCamera = false;
    }

    public boolean addTracker(TrackingPacket tracker) {
        if (!tracker.combiningMorphs) {
            this.registerTracker(tracker);
        } else {
            JsonArray frames;
            int endFrame = this.getFrame() - 100;
            if (this.registeredTrackingPackets.containsKey(tracker.name) && (frames = this.morphData.getAsJsonArray(tracker.name)).size() > 0) {
                int startFrame = frames.get(0).getAsJsonObject().get("frame").getAsInt();
                endFrame = startFrame + frames.size() - 1;
            }
            if (this.getFrame() - 1 == endFrame) {
                tracker.trackingData = this.morphData.getAsJsonArray(tracker.name);
            } else {
                this.registerTracker(tracker);
            }
        }
        return true;
    }

    private void registerTracker(TrackingPacket tracker) {
        tracker.name = this.checkDuplicateName(tracker.name, this.registeredTrackingPackets);
        this.morphData.add(tracker.name, (JsonElement)tracker.trackingData);
        this.registeredTrackingPackets.put(tracker.name, tracker);
    }

    private String checkDuplicateName(String name, Map map) {
        int counter = 0;
        while (map.containsKey(name + (counter == 0 ? "" : "." + counter))) {
            ++counter;
        }
        return name + (counter == 0 ? "" : "." + counter);
    }

    @Optional.Method(modid="minema")
    public void start(CameraRunner runner) {
        if (this.building) {
            return;
        }
        this.wrapper.add("information", (JsonElement)this.getHeaderInformation());
        this.wrapper.add("camera_tracking", (JsonElement)this.cameraData);
        this.wrapper.add("entity_tracking", (JsonElement)this.entityData);
        this.wrapper.add("morph_tracking", (JsonElement)this.morphData);
        this.runner = runner;
        this.building = true;
        this.motionblurFrames = Math.round(Minema.instance.getConfig().getFrameRate()) / (long)((int)Minema.instance.getConfig().frameRate.get().doubleValue());
        MinemaEventbus.cameraBUS.registerListener(e -> this.addCameraFrame());
        MinemaEventbus.endRenderBUS.registerListener(e -> this.frameEnd());
    }

    @Optional.Method(modid="minema")
    public boolean skipFrame() {
        boolean ignoreMotionblurFrame = this.frame % (int)this.motionblurFrames != 0;
        return !this.building || this.heldframes < Minema.instance.getConfig().heldFrames.get() || ignoreMotionblurFrame || TimerModifier.getCubeFace() != CubeFace.FRONT;
    }

    @Optional.Method(modid="minema")
    public void frameEnd() {
        this.addEntitiesData(Minecraft.func_71410_x().func_184121_ak());
        this.frame = this.heldframes >= Minema.instance.getConfig().heldFrames.get() ? this.frame + 1 : this.frame;
    }

    @Optional.Method(modid="minema")
    private void updateHeldFrames() {
        int minemaHF = Minema.instance.getConfig().heldFrames.get();
        this.heldframes = this.heldframes < minemaHF ? this.heldframes + 1 : 1;
    }

    @Optional.Method(modid="minema")
    public JsonObject getHeaderInformation() {
        JsonObject information = new JsonObject();
        JsonArray resolution = new JsonArray();
        resolution.add((Number)Minema.instance.getConfig().frameWidth.get());
        resolution.add((Number)Minema.instance.getConfig().frameHeight.get());
        information.add("fps", (JsonElement)new JsonPrimitive((Number)Minema.instance.getConfig().frameRate.get()));
        information.add("motionblur_fps", (JsonElement)new JsonPrimitive((Number)Minema.instance.getConfig().frameRate.get()));
        information.add("dynamic_fov", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        information.add("resolution", (JsonElement)resolution);
        information.add("held_frames", (JsonElement)new JsonPrimitive((Number)Minema.instance.getConfig().heldFrames.get()));
        information.add("required_import_version", (JsonElement)new JsonPrimitive((Number)160));
        return information;
    }

    public void track(TrackingPacket tracker) {
        if (this.skipFrame()) {
            return;
        }
        if (!this.trackedCamera) {
            return;
        }
        Vector3d pos = new Vector3d();
        Vector3d scale = new Vector3d();
        Matrix4d[] transformation = MatrixUtils.getTransformation();
        pos.x = transformation[0].m03;
        pos.y = transformation[0].m13;
        pos.z = transformation[0].m23;
        Matrix4d rotation = transformation[1];
        scale.x = transformation[2].m00;
        scale.y = transformation[2].m11;
        scale.z = transformation[2].m22;
        JsonObject frame = new JsonObject();
        JsonArray positionData = new JsonArray();
        JsonArray rotationData = new JsonArray();
        JsonArray scaleData = new JsonArray();
        positionData.add((Number)(pos.x - this.trackingInitialPos[0]));
        positionData.add((Number)(pos.y - this.trackingInitialPos[1]));
        positionData.add((Number)(pos.z - this.trackingInitialPos[2]));
        JsonArray jsonRotX = new JsonArray();
        jsonRotX.add((Number)rotation.m00);
        jsonRotX.add((Number)rotation.m01);
        jsonRotX.add((Number)rotation.m02);
        JsonArray jsonRotY = new JsonArray();
        jsonRotY.add((Number)rotation.m10);
        jsonRotY.add((Number)rotation.m11);
        jsonRotY.add((Number)rotation.m12);
        JsonArray jsonRotZ = new JsonArray();
        jsonRotZ.add((Number)rotation.m20);
        jsonRotZ.add((Number)rotation.m21);
        jsonRotZ.add((Number)rotation.m22);
        rotationData.add((JsonElement)jsonRotX);
        rotationData.add((JsonElement)jsonRotY);
        rotationData.add((JsonElement)jsonRotZ);
        scaleData.add((Number)scale.x);
        scaleData.add((Number)scale.y);
        scaleData.add((Number)scale.z);
        if (tracker.trackingData.size() == 0) {
            frame.addProperty("frame", (Number)this.getFrame());
        }
        frame.add("position", (JsonElement)positionData);
        frame.add("rotation", (JsonElement)rotationData);
        frame.add("scale", (JsonElement)scaleData);
        tracker.trackingData.add((JsonElement)frame);
    }

    private void addEntitiesData(float partialTick) {
        if (this.skipFrame()) {
            return;
        }
        this.tryFindingEntity();
        for (Entity entity : this.entities) {
            JsonArray frameArray = this.addEntityTracker(entity);
            double x = Interpolations.lerp((double)entity.field_70142_S, (double)entity.field_70165_t, (double)partialTick);
            double y = Interpolations.lerp((double)entity.field_70137_T, (double)entity.field_70163_u, (double)partialTick);
            double z = Interpolations.lerp((double)entity.field_70136_U, (double)entity.field_70161_v, (double)partialTick);
            JsonObject frame = new JsonObject();
            JsonArray positionData = new JsonArray();
            JsonArray angleData = new JsonArray();
            positionData.add((Number)(x - this.trackingInitialPos[0]));
            positionData.add((Number)(y - this.trackingInitialPos[1]));
            positionData.add((Number)(z - this.trackingInitialPos[2]));
            if (frameArray.size() == 0) {
                frame.addProperty("frame", (Number)this.getFrame());
            }
            frame.add("position", (JsonElement)positionData);
            if (entity instanceof EntityLivingBase) {
                double bodyYaw = ((EntityLivingBase)entity).field_70760_ar + (((EntityLivingBase)entity).field_70761_aq - ((EntityLivingBase)entity).field_70760_ar) * partialTick;
                angleData.add((Number)0);
                angleData.add((Number)bodyYaw);
                angleData.add((Number)0);
                frame.add("body_rotation", (JsonElement)angleData);
            }
            frameArray.add((JsonElement)frame);
        }
    }

    private JsonArray addEntityTracker(Entity entity) {
        JsonArray frameArray;
        String name = (String)this.entityNameRemaps.inverse().get((Object)entity.func_189512_bd());
        if (name != null) {
            frameArray = this.entityData.getAsJsonArray(name);
        } else {
            name = this.checkDuplicateName(entity.func_70005_c_(), (Map)this.entityNameRemaps);
            frameArray = new JsonArray();
            this.entityData.add(name, (JsonElement)frameArray);
            this.entityNameRemaps.put((Object)name, (Object)entity.func_189512_bd());
        }
        return frameArray;
    }

    @Optional.Method(modid="minema")
    private void addCameraFrame() {
        this.updateHeldFrames();
        if (this.skipFrame()) {
            return;
        }
        this.readMVP();
        this.camera.set(this.modelview);
        this.trackedCamera = true;
        Matrix4d translation = new Matrix4d();
        Minecraft mc = Minecraft.func_71410_x();
        Entity renderEntity = mc.func_175606_aa();
        double x = Interpolations.lerp((double)renderEntity.field_70142_S, (double)renderEntity.field_70165_t, (double)mc.func_184121_ak());
        double y = Interpolations.lerp((double)renderEntity.field_70137_T, (double)renderEntity.field_70163_u, (double)mc.func_184121_ak());
        double z = Interpolations.lerp((double)renderEntity.field_70136_U, (double)renderEntity.field_70161_v, (double)mc.func_184121_ak());
        translation.setIdentity();
        translation.setTranslation(new Vector3d(-x, -y, -z));
        this.modelview.mul(translation);
        this.modelview.invert();
        Vector3d pos = new Vector3d(this.modelview.m03, this.modelview.m13, this.modelview.m23);
        if (this.frame == 0 && !this.relativeOrigin) {
            this.trackingInitialPos[0] = pos.x;
            this.trackingInitialPos[1] = pos.y;
            this.trackingInitialPos[2] = pos.z;
        }
        JsonObject frame = new JsonObject();
        JsonArray positionData = new JsonArray();
        JsonArray angleData = new JsonArray();
        positionData.add((Number)(pos.x - this.trackingInitialPos[0]));
        positionData.add((Number)(pos.y - this.trackingInitialPos[1]));
        positionData.add((Number)(pos.z - this.trackingInitialPos[2]));
        angleData.add((Number)Float.valueOf(this.runner.getPosition().angle.fov));
        angleData.add((Number)Float.valueOf(this.runner.getPosition().angle.roll));
        angleData.add((Number)Float.valueOf(this.runner.getPosition().angle.yaw));
        angleData.add((Number)Float.valueOf(this.runner.getPosition().angle.pitch));
        frame.add("position", (JsonElement)positionData);
        frame.add("angle", (JsonElement)angleData);
        this.cameraData.add((JsonElement)frame);
    }

    @Optional.Method(modid="minema")
    public void exportTrackingData(String filename) {
        try {
            BufferedWriter file = Files.newBufferedWriter(CaptureSession.singleton.getCaptureDir().resolve(Paths.get(filename, new String[0])), StandardCharsets.UTF_8, new OpenOption[0]);
            file.write(this.wrapper.toString());
            file.close();
            System.out.println("Successfully created the tracking data file.");
        }
        catch (IOException e) {
            System.out.println("An error occurred during writing the tracking data file.");
            e.printStackTrace();
        }
    }

    public void tryFindingEntity() {
        this.entities.clear();
        if (this.selector != null && !this.selector.isEmpty() && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            String[] selectorArray = this.selector.split(" - ");
            this.tryFindingEntityClient(selectorArray);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void tryFindingEntityClient(String[] selectorArray) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        for (String selector : selectorArray) {
            if (!selector.contains("@")) {
                selector = "@e[name=" + selector + "]";
            }
            try {
                this.entities.addAll(EntitySelector.matchEntities((ICommandSender)player, selector, Entity.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class TrackingPacket {
        private String name;
        private JsonArray trackingData = new JsonArray();
        private boolean reset = false;
        private boolean combiningMorphs;

        public TrackingPacket(String name, boolean combiningMorphs) {
            this.name = name;
            this.combiningMorphs = combiningMorphs;
        }

        public boolean isReset() {
            return this.reset;
        }

        public String getName() {
            return this.name;
        }

        private void reset() {
            this.trackingData = new JsonArray();
            this.reset = true;
        }
    }
}

