/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera;

import java.util.Objects;
import mchorse.aperture.Aperture;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.destination.AbstractDestination;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.GuiProfilesManager;
import mchorse.mclib.utils.EntityUtils;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.client.Minecraft;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CameraControl {
    public CameraProfile currentProfile;
    private boolean prevRollMode;
    private float prevRoll;
    public float roll = 0.0f;
    public int lastCounter;
    public float lastRoll;
    public float lastFov;
    public int lastThirdPersonView;
    public GameType lastGameMode = GameType.NOT_SET;

    public void cache() {
        if (this.lastCounter == 0) {
            Minecraft mc = Minecraft.func_71410_x();
            this.lastGameMode = EntityUtils.getGameMode();
            this.lastRoll = this.roll;
            this.lastFov = mc.field_71474_y.field_74334_X;
            this.lastThirdPersonView = mc.field_71474_y.field_74320_O;
        }
        ++this.lastCounter;
    }

    public void restore() {
        --this.lastCounter;
        if (this.lastCounter == 0) {
            Minecraft mc = Minecraft.func_71410_x();
            this.roll = this.lastRoll;
            mc.field_71474_y.field_74334_X = this.lastFov;
            mc.field_71474_y.field_74320_O = this.lastThirdPersonView;
            if (this.lastGameMode != EntityUtils.getGameMode()) {
                mc.field_71439_g.func_71165_d("/gamemode " + this.lastGameMode.func_77148_a());
            }
            this.lastFov = 0.0f;
            this.lastRoll = 0.0f;
        }
    }

    public void reset() {
        GuiCameraEditor cameraEditor;
        if (((Boolean)Aperture.profileAutoSave.get()).booleanValue() && (cameraEditor = ClientProxy.cameraEditor) != null) {
            this.saveCameraProfiles(cameraEditor);
        }
        this.currentProfile = null;
        this.lastCounter = 0;
        this.lastFov = 0.0f;
        this.lastRoll = 0.0f;
        this.lastGameMode = null;
    }

    private void saveCameraProfiles(GuiCameraEditor editor) {
        GuiProfilesManager manager = editor.profiles;
        for (CameraProfile profile : manager.profiles.list.getList()) {
            if (!profile.dirty) continue;
            profile.save();
        }
    }

    public CameraProfile getProfile(AbstractDestination destination) {
        GuiCameraEditor editor = ClientProxy.cameraEditor;
        GuiProfilesManager manager = editor.profiles;
        for (CameraProfile profile : manager.profiles.list.getList()) {
            if (!Objects.equals(profile.destination, destination)) continue;
            return profile;
        }
        return null;
    }

    public void setRoll(float value) {
        this.prevRollMode = false;
        ClientProxy.renderer.roll.reset(value);
        this.roll = value;
    }

    public void setRoll(float prevValue, float value) {
        this.prevRollMode = true;
        ClientProxy.renderer.roll.reset(value);
        this.prevRoll = prevValue;
        this.roll = value;
    }

    public void resetRoll() {
        this.setRoll(0.0f);
    }

    public void setFOV(float value) {
        ClientProxy.renderer.fov.reset(value);
        Minecraft.func_71410_x().field_71474_y.field_74334_X = value;
    }

    public void resetFOV() {
        this.setFOV(70.0f);
    }

    public void setRollAndFOV(float roll, float fov) {
        this.setRoll(roll);
        this.setFOV(fov);
    }

    public float getRoll(float partialTicks) {
        return this.prevRollMode ? Interpolations.lerp((float)this.prevRoll, (float)this.roll, (float)partialTicks) : this.roll;
    }
}

