/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture.camera;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import mchorse.aperture.ClientProxy;
import mchorse.aperture.camera.CameraUtils;
import mchorse.aperture.camera.destination.AbstractDestination;
import mchorse.aperture.camera.destination.ServerDestination;
import mchorse.aperture.network.Dispatcher;
import mchorse.aperture.network.common.PacketCameraState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CameraAPI {
    public static void playCameraProfile(EntityPlayerMP player, ResourceLocation resource) {
        CameraAPI.playCameraProfile(player, AbstractDestination.fromResourceLocation(resource));
    }

    public static void playCameraProfile(EntityPlayerMP player, AbstractDestination destination) {
        if (destination instanceof ServerDestination) {
            CameraUtils.sendProfileToPlayer(destination.getFilename(), player, true, false);
        } else {
            Dispatcher.sendTo(new PacketCameraState(destination.getFilename(), true), player);
        }
    }

    public static void playCurrentProfile(EntityPlayerMP player) {
        Dispatcher.sendTo(new PacketCameraState(true), player);
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getClientProfiles() {
        ArrayList<String> files = new ArrayList<String>();
        File folder = ClientProxy.getClientCameras();
        File[] profiles = null;
        if (folder != null) {
            profiles = folder.listFiles(new JSONFileFilter());
        }
        if (profiles != null) {
            for (File file : profiles) {
                String filename = file.getName();
                filename = filename.substring(0, filename.lastIndexOf(".json"));
                files.add(filename);
            }
        }
        return files;
    }

    public static List<String> getServerProfiles() {
        File file = new File(DimensionManager.getCurrentSaveRootDirectory() + "/aperture/cameras");
        ArrayList<String> files = new ArrayList<String>();
        file.mkdirs();
        for (File profile : file.listFiles(new JSONFileFilter())) {
            String filename = profile.getName();
            files.add(filename.substring(0, filename.lastIndexOf(".json")));
        }
        return files;
    }

    public static class JSONFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".json");
        }
    }
}

