/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture;

import java.io.File;
import java.util.HashMap;
import mchorse.aperture.Aperture;
import mchorse.aperture.CommonProxy;
import mchorse.aperture.camera.CameraControl;
import mchorse.aperture.camera.CameraRenderer;
import mchorse.aperture.camera.CameraRunner;
import mchorse.aperture.camera.CurveManager;
import mchorse.aperture.camera.FixtureRegistry;
import mchorse.aperture.camera.ModifierRegistry;
import mchorse.aperture.camera.fixtures.AbstractFixture;
import mchorse.aperture.camera.fixtures.CircularFixture;
import mchorse.aperture.camera.fixtures.DollyFixture;
import mchorse.aperture.camera.fixtures.IdleFixture;
import mchorse.aperture.camera.fixtures.KeyframeFixture;
import mchorse.aperture.camera.fixtures.ManualFixture;
import mchorse.aperture.camera.fixtures.NullFixture;
import mchorse.aperture.camera.fixtures.PathFixture;
import mchorse.aperture.camera.modifiers.AbstractModifier;
import mchorse.aperture.camera.modifiers.AngleModifier;
import mchorse.aperture.camera.modifiers.DollyZoomModifier;
import mchorse.aperture.camera.modifiers.DragModifier;
import mchorse.aperture.camera.modifiers.FollowModifier;
import mchorse.aperture.camera.modifiers.LookModifier;
import mchorse.aperture.camera.modifiers.MathModifier;
import mchorse.aperture.camera.modifiers.OrbitModifier;
import mchorse.aperture.camera.modifiers.RemapperModifier;
import mchorse.aperture.camera.modifiers.ShakeModifier;
import mchorse.aperture.camera.modifiers.TranslateModifier;
import mchorse.aperture.client.KeyboardHandler;
import mchorse.aperture.client.RenderingHandler;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.client.gui.GuiModifiersManager;
import mchorse.aperture.client.gui.panels.GuiCircularFixturePanel;
import mchorse.aperture.client.gui.panels.GuiDollyFixturePanel;
import mchorse.aperture.client.gui.panels.GuiIdleFixturePanel;
import mchorse.aperture.client.gui.panels.GuiKeyframeFixturePanel;
import mchorse.aperture.client.gui.panels.GuiManualFixturePanel;
import mchorse.aperture.client.gui.panels.GuiNullFixturePanel;
import mchorse.aperture.client.gui.panels.GuiPathFixturePanel;
import mchorse.aperture.client.gui.panels.modifiers.GuiAngleModifierPanel;
import mchorse.aperture.client.gui.panels.modifiers.GuiDollyZoomModifierPanel;
import mchorse.aperture.client.gui.panels.modifiers.GuiDragModifierPanel;
import mchorse.aperture.client.gui.panels.modifiers.GuiFollowModifierPanel;
import mchorse.aperture.client.gui.panels.modifiers.GuiLookModifierPanel;
import mchorse.aperture.client.gui.panels.modifiers.GuiMathModifierPanel;
import mchorse.aperture.client.gui.panels.modifiers.GuiOrbitModifierPanel;
import mchorse.aperture.client.gui.panels.modifiers.GuiRemapperModifierPanel;
import mchorse.aperture.client.gui.panels.modifiers.GuiShakeModifierPanel;
import mchorse.aperture.client.gui.panels.modifiers.GuiTranslateModifierPanel;
import mchorse.aperture.commands.CommandCamera;
import mchorse.aperture.commands.CommandLoadChunks;
import mchorse.aperture.utils.OptifineHelper;
import mchorse.aperture.utils.mclib.ValueShaderOption;
import mchorse.mclib.McLib;
import mchorse.mclib.config.ConfigBuilder;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.OpHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static boolean server = false;
    public static CameraRenderer renderer = new CameraRenderer();
    public static CameraControl control = new CameraControl();
    public static CameraRunner runner;
    public static CurveManager curveManager;
    public static KeyboardHandler keys;
    public static EventBus EVENT_BUS;
    public static File config;
    public static File cameras;
    public static GuiCameraEditor cameraEditor;

    public static GuiCameraEditor getCameraEditor() {
        if (cameraEditor == null) {
            cameraEditor = new GuiCameraEditor(Minecraft.func_71410_x(), runner);
        }
        return cameraEditor;
    }

    public static GuiCameraEditor openCameraEditor() {
        Minecraft mc = Minecraft.func_71410_x();
        GuiCameraEditor editor = ClientProxy.getCameraEditor();
        editor.updateCameraEditor((EntityPlayer)mc.field_71439_g);
        mc.field_71439_g.func_70016_h(0.0, 0.0, 0.0);
        mc.func_147108_a((GuiScreen)editor);
        return editor;
    }

    public static File getClientCameras() {
        Minecraft mc = Minecraft.func_71410_x();
        ServerData data = mc.func_147104_D();
        File file = null;
        if (data != null) {
            file = new File(cameras, data.field_78845_b.replaceAll(":[\\w]{1,5}$", "").replaceAll("[^\\w\\d_\\- ]", "_"));
        } else if (mc.func_71356_B()) {
            file = new File(cameras, mc.func_71401_C().func_71221_J().replaceAll("[^\\w\\d_\\- ]", "_"));
        }
        if (file != null) {
            file.mkdirs();
        }
        return file;
    }

    public static boolean canUseCameraEditor() {
        return Minecraft.func_71410_x().func_71356_B() || (Boolean)Aperture.opCameraEditor.get() != false || OpHelper.isPlayerOp();
    }

    @Override
    public void preLoad(FMLPreInitializationEvent event) {
        FixtureRegistry.CLIENT = new HashMap<Class<? extends AbstractFixture>, FixtureRegistry.FixtureInfo>();
        ModifierRegistry.CLIENT = new HashMap<Class<? extends AbstractModifier>, ModifierRegistry.ModifierInfo>();
        config = new File(event.getModConfigurationDirectory(), "aperture");
        cameras = new File(config, "cameras");
        super.preLoad(event);
        runner = new CameraRunner();
    }

    @Override
    public void load(FMLInitializationEvent event) {
        GuiCameraEditor.PANELS.put(IdleFixture.class, GuiIdleFixturePanel.class);
        GuiCameraEditor.PANELS.put(PathFixture.class, GuiPathFixturePanel.class);
        GuiCameraEditor.PANELS.put(CircularFixture.class, GuiCircularFixturePanel.class);
        GuiCameraEditor.PANELS.put(KeyframeFixture.class, GuiKeyframeFixturePanel.class);
        GuiCameraEditor.PANELS.put(NullFixture.class, GuiNullFixturePanel.class);
        GuiCameraEditor.PANELS.put(ManualFixture.class, GuiManualFixturePanel.class);
        GuiCameraEditor.PANELS.put(DollyFixture.class, GuiDollyFixturePanel.class);
        FixtureRegistry.registerClient(IdleFixture.class, "aperture.gui.fixtures.idle", new Color(0.085f, 0.62f, 0.395f));
        FixtureRegistry.registerClient(PathFixture.class, "aperture.gui.fixtures.path", new Color(0.408f, 0.128f, 0.681f));
        FixtureRegistry.registerClient(CircularFixture.class, "aperture.gui.fixtures.circular", new Color(0.298f, 0.631f, 0.247f));
        FixtureRegistry.registerClient(KeyframeFixture.class, "aperture.gui.fixtures.keyframe", new Color(0.874f, 0.184f, 0.625f));
        FixtureRegistry.registerClient(NullFixture.class, "aperture.gui.fixtures.null", new Color(0.1f, 0.1f, 0.12f));
        FixtureRegistry.registerClient(ManualFixture.class, "aperture.gui.fixtures.manual", new Color().set(20659));
        FixtureRegistry.registerClient(DollyFixture.class, "aperture.gui.fixtures.dolly", new Color().set(16753920));
        GuiModifiersManager.PANELS.put(ShakeModifier.class, GuiShakeModifierPanel.class);
        GuiModifiersManager.PANELS.put(MathModifier.class, GuiMathModifierPanel.class);
        GuiModifiersManager.PANELS.put(LookModifier.class, GuiLookModifierPanel.class);
        GuiModifiersManager.PANELS.put(FollowModifier.class, GuiFollowModifierPanel.class);
        GuiModifiersManager.PANELS.put(TranslateModifier.class, GuiTranslateModifierPanel.class);
        GuiModifiersManager.PANELS.put(AngleModifier.class, GuiAngleModifierPanel.class);
        GuiModifiersManager.PANELS.put(OrbitModifier.class, GuiOrbitModifierPanel.class);
        GuiModifiersManager.PANELS.put(DragModifier.class, GuiDragModifierPanel.class);
        GuiModifiersManager.PANELS.put(RemapperModifier.class, GuiRemapperModifierPanel.class);
        GuiModifiersManager.PANELS.put(DollyZoomModifier.class, GuiDollyZoomModifierPanel.class);
        ModifierRegistry.registerClient(ShakeModifier.class, "aperture.gui.modifiers.shake", new Color(0.085f, 0.62f, 0.395f));
        ModifierRegistry.registerClient(MathModifier.class, "aperture.gui.modifiers.math", new Color(0.408f, 0.128f, 0.681f));
        ModifierRegistry.registerClient(LookModifier.class, "aperture.gui.modifiers.look", new Color(0.1f, 0.5f, 1.0f));
        ModifierRegistry.registerClient(FollowModifier.class, "aperture.gui.modifiers.follow", new Color(0.85f, 0.137f, 0.329f));
        ModifierRegistry.registerClient(TranslateModifier.class, "aperture.gui.modifiers.translate", new Color(0.298f, 0.631f, 0.247f));
        ModifierRegistry.registerClient(AngleModifier.class, "aperture.gui.modifiers.angle", new Color(0.847f, 0.482f, 0.043f));
        ModifierRegistry.registerClient(OrbitModifier.class, "aperture.gui.modifiers.orbit", new Color(0.874f, 0.184f, 0.625f));
        ModifierRegistry.registerClient(DragModifier.class, "aperture.gui.modifiers.drag", new Color(0.298f, 0.69f, 0.972f));
        ModifierRegistry.registerClient(RemapperModifier.class, "aperture.gui.modifiers.remapper", new Color().set(0x111111));
        ModifierRegistry.registerClient(DollyZoomModifier.class, "aperture.gui.modifiers.dolly_zoom", new Color().set(0x222222));
        super.load(event);
        RenderingHandler handler = new RenderingHandler();
        McLib.EVENT_BUS.register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)handler);
        keys = new KeyboardHandler();
        MinecraftForge.EVENT_BUS.register((Object)keys);
        MinecraftForge.EVENT_BUS.register((Object)renderer);
        ClientProxy.renderer.smooth.enabled = Aperture.smooth;
        ClientProxy.renderer.smooth.fricX = Aperture.smoothFricX;
        ClientProxy.renderer.smooth.fricY = Aperture.smoothFricY;
        ClientProxy.renderer.roll.friction = Aperture.rollFriction;
        ClientProxy.renderer.roll.factor = Aperture.rollFactor;
        ClientProxy.renderer.fov.friction = Aperture.fovFriction;
        ClientProxy.renderer.fov.factor = Aperture.fovFactor;
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCamera());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandLoadChunks());
    }

    @Override
    public String getLanguageString(String key, String defaultComment) {
        String comment = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        return comment.equals(key) ? defaultComment : comment;
    }

    @Override
    public void registerClientConfig(ConfigBuilder builder) {
        Aperture.minemaDefaultProfileName = builder.category("minema").getBoolean("default_profile_name", false);
        builder.getCategory().markClientSide();
        Aperture.optifineShaderOptionCurve = builder.category("optifine").getBoolean("shader_option_curve", true);
        Aperture.optifineShaderOptionCurve.invisible();
        builder.register(new ValueShaderOption("option").clientSide());
        builder.getCategory().markClientSide();
        if (!OptifineHelper.shaderpackSupported) {
            builder.getCategory().invisible();
        }
    }

    static {
        curveManager = new CurveManager();
        EVENT_BUS = new EventBus();
    }
}

