/*
 * Decompiled with CFR 0.152.
 */
package mchorse.aperture;

import mchorse.aperture.CommonProxy;
import mchorse.aperture.commands.CommandAperture;
import mchorse.mclib.McLib;
import mchorse.mclib.commands.utils.L10n;
import mchorse.mclib.config.ConfigBuilder;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueFloat;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.config.values.ValueRL;
import mchorse.mclib.config.values.ValueString;
import mchorse.mclib.events.RegisterConfigEvent;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="aperture", name="Aperture", version="1.8.2", dependencies="after:minema@[%MINEMA%,);required-after:mclib@[2.4.2,)", updateJSON="https://raw.githubusercontent.com/mchorse/aperture/1.12/version.json", acceptedMinecraftVersions="[1.12.2]")
public class Aperture {
    public static final String MOD_ID = "aperture";
    public static final String MODNAME = "Aperture";
    public static final String VERSION = "1.8.2";
    public static final String CLIENT_PROXY = "mchorse.aperture.ClientProxy";
    public static final String SERVER_PROXY = "mchorse.aperture.CommonProxy";
    @Mod.Instance
    public static Aperture instance;
    @SidedProxy(clientSide="mchorse.aperture.ClientProxy", serverSide="mchorse.aperture.CommonProxy")
    public static CommonProxy proxy;
    public static Logger LOGGER;
    public static L10n l10n;
    public static ValueBoolean opCameraEditor;
    public static ValueInt duration;
    public static ValueBoolean spectator;
    public static ValueFloat stepFactor;
    public static ValueFloat rotateFactor;
    public static ValueString commandName;
    public static ValueBoolean debugTicks;
    public static ValueBoolean profileRender;
    public static ValueBoolean profileAutoSave;
    public static ValueBoolean essentialsTeleport;
    public static ValueBoolean outside;
    public static ValueBoolean outsideHidePlayer;
    public static ValueBoolean outsideSky;
    public static ValueBoolean editorSync;
    public static ValueBoolean editorLoop;
    public static ValueBoolean editorOverlay;
    public static ValueRL editorOverlayRL;
    public static ValueBoolean editorF1Tooltip;
    public static ValueBoolean editorDisplayPosition;
    public static ValueInt editorGuidesColor;
    public static ValueBoolean editorRuleOfThirds;
    public static ValueBoolean editorCenterLines;
    public static ValueBoolean editorCrosshair;
    public static ValueBoolean editorLetterbox;
    public static ValueString editorLetterboxAspect;
    public static ValueBoolean editorHideChat;
    public static ValueBoolean editorSeconds;
    public static ValueInt editorAutoSave;
    public static ValueInt flightForward;
    public static ValueInt flightBackward;
    public static ValueInt flightLeft;
    public static ValueInt flightRight;
    public static ValueInt flightUp;
    public static ValueInt flightDown;
    public static ValueInt flightCameraUp;
    public static ValueInt flightCameraDown;
    public static ValueInt flightCameraLeft;
    public static ValueInt flightCameraRight;
    public static ValueInt flightCameraFovMinus;
    public static ValueInt flightCameraFovPlus;
    public static ValueInt flightCameraRollMinus;
    public static ValueInt flightCameraRollPlus;
    public static ValueInt flightCameraSpeedMinus;
    public static ValueInt flightCameraSpeedPlus;
    public static ValueBoolean smoothClampPitch;
    public static ValueBoolean smooth;
    public static ValueFloat smoothFricX;
    public static ValueFloat smoothFricY;
    public static ValueFloat rollFriction;
    public static ValueFloat rollFactor;
    public static ValueFloat fovFriction;
    public static ValueFloat fovFactor;
    public static ValueBoolean minemaDefaultProfileName;
    public static ValueBoolean optifineShaderOptionCurve;

    @SubscribeEvent
    public void onConfigRegister(RegisterConfigEvent event) {
        opCameraEditor = event.opAccess.category(MOD_ID).getBoolean("camera_editor", true);
        opCameraEditor.syncable();
        ConfigBuilder builder = event.createBuilder(MOD_ID);
        duration = builder.category("general").getInt("duration", 30, 1, 1000);
        spectator = builder.getBoolean("spectator", true);
        stepFactor = builder.getFloat("step_factor", 0.01f, 0.0f, 10.0f);
        rotateFactor = builder.getFloat("rotate_factor", 0.1f, 0.0f, 10.0f);
        commandName = builder.getString("command_name", "camera");
        debugTicks = builder.getBoolean("debug_ticks", false);
        profileRender = builder.getBoolean("profile_render", true);
        profileAutoSave = builder.getBoolean("auto_save", true);
        essentialsTeleport = builder.getBoolean("essentials_tp", false);
        String camera_command_name = ((String)commandName.get()).trim().replaceAll("[^\\w\\d_\\-]+", "");
        if (camera_command_name.isEmpty()) {
            commandName.set((Object)"camera");
        }
        builder.getCategory().markClientSide();
        outside = builder.category("outside").getBoolean("enabled", false);
        outsideHidePlayer = builder.getBoolean("hide_player", false);
        outsideSky = builder.getBoolean("sky", true);
        builder.getCategory().markClientSide();
        editorSync = builder.category("editor").getBoolean("sync", false);
        editorLoop = builder.getBoolean("loop", false);
        editorOverlay = builder.getBoolean("overlay", false);
        editorOverlayRL = builder.getRL("overlay_rl", null);
        editorF1Tooltip = builder.getBoolean("f1_tooltip", true);
        editorDisplayPosition = builder.getBoolean("position", false);
        editorGuidesColor = builder.getInt("guides_color", -859045888).colorAlpha();
        editorRuleOfThirds = builder.getBoolean("rule_of_thirds", false);
        editorCenterLines = builder.getBoolean("center_lines", false);
        editorCrosshair = builder.getBoolean("crosshair", false);
        editorLetterbox = builder.getBoolean("letter_box", false);
        editorLetterboxAspect = builder.getString("aspect_ratio", "21:9");
        editorHideChat = builder.getBoolean("hide_chat", true);
        editorSeconds = builder.getBoolean("seconds", false);
        editorAutoSave = builder.getInt("auto_save", 0, 0, 600);
        builder.getCategory().markClientSide();
        flightForward = builder.category("flight").getInt("forward", 17).keybind();
        flightBackward = builder.getInt("backward", 31).keybind();
        flightLeft = builder.getInt("left", 30).keybind();
        flightRight = builder.getInt("right", 32).keybind();
        flightUp = builder.getInt("up", 57).keybind();
        flightDown = builder.getInt("down", 42).keybind();
        flightCameraUp = builder.getInt("camera_up", 200).keybind();
        flightCameraDown = builder.getInt("camera_down", 208).keybind();
        flightCameraLeft = builder.getInt("camera_left", 203).keybind();
        flightCameraRight = builder.getInt("camera_right", 205).keybind();
        flightCameraFovMinus = builder.getInt("fov_minus", 26).keybind();
        flightCameraFovPlus = builder.getInt("fov_plus", 27).keybind();
        flightCameraRollMinus = builder.getInt("roll_minus", 40).keybind();
        flightCameraRollPlus = builder.getInt("roll_plus", 43).keybind();
        flightCameraSpeedMinus = builder.getInt("speed_minus", 24).keybind();
        flightCameraSpeedPlus = builder.getInt("speed_plus", 25).keybind();
        builder.getCategory().markClientSide();
        smooth = builder.category("smooth").getBoolean("enabled", false);
        smoothClampPitch = builder.getBoolean("clamp", true);
        smoothFricX = builder.getFloat("x_friction", 0.92f, 0.0f, 1.0f);
        smoothFricY = builder.getFloat("y_friction", 0.92f, 0.0f, 1.0f);
        rollFriction = builder.getFloat("roll_friction", 0.985f, 0.0f, 0.99999f);
        rollFactor = builder.getFloat("roll_speed", 0.01f, 0.0f, 10.0f);
        fovFriction = builder.getFloat("fov_friction", 0.985f, 0.0f, 0.99999f);
        fovFactor = builder.getFloat("fov_speed", 0.075f, 0.0f, 10.0f);
        builder.getCategory().markClientSide();
        proxy.registerClientConfig(builder);
    }

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        McLib.EVENT_BUS.register((Object)this);
        proxy.preLoad(event);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.load(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandAperture());
    }

    static {
        l10n = new L10n(MOD_ID);
    }
}

