/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.permissions;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mchorse.mclib.network.IByteBufSerializable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class PermissionCategory
implements IByteBufSerializable {
    private String name;
    private final List<PermissionCategory> children = new ArrayList<PermissionCategory>();
    private PermissionCategory parent;
    private DefaultPermissionLevel level;

    public PermissionCategory(String name) {
        this(name, null);
    }

    public PermissionCategory(String name, DefaultPermissionLevel level) {
        this.name = name;
        this.level = level;
    }

    private PermissionCategory() {
    }

    public boolean playerHasPermission(EntityPlayer player) {
        return PermissionAPI.hasPermission((EntityPlayer)player, (String)this.toString());
    }

    public void addChild(PermissionCategory category) {
        this.children.add(category);
        category.parent = this;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<PermissionCategory> getChildren() {
        return new ArrayList<PermissionCategory>(this.children);
    }

    public PermissionCategory getParent() {
        return this.parent;
    }

    public DefaultPermissionLevel getDefaultPermission() {
        if (this.level == null) {
            return this.parent != null ? this.parent.getDefaultPermission() : DefaultPermissionLevel.NONE;
        }
        return this.level;
    }

    public String toString() {
        return (this.parent != null ? this.parent + "." : "") + this.name;
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.level = DefaultPermissionLevel.values()[buffer.readInt()];
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            PermissionCategory child = new PermissionCategory();
            child.fromBytes(buffer);
            this.addChild(child);
        }
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        buffer.writeInt(this.level.ordinal());
        buffer.writeInt(this.children.size());
        for (PermissionCategory category : this.children) {
            category.toBytes(buffer);
        }
    }
}

