/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.render;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class VertexBuilder {
    public static final VertexFormat[] cache = new VertexFormat[4];
    public static int entityAttrib = -1;
    public static int midTexCoordAttrib = -1;
    public static int tangentAttrib = -1;
    public static int velocityAttrib = -1;
    public static int midBlockAttrib = -1;

    public static VertexFormat getFormat(boolean color, boolean tex, boolean lightmap, boolean normal) {
        int index = (color ? 1 : 0) | (lightmap ? 2 : 0);
        if (cache[index] == null) {
            VertexFormat vertexformat = new VertexFormat();
            vertexformat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.POSITION, 3));
            vertexformat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.UBYTE, color ? VertexFormatElement.EnumUsage.COLOR : VertexFormatElement.EnumUsage.PADDING, 4));
            vertexformat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, tex ? VertexFormatElement.EnumUsage.UV : VertexFormatElement.EnumUsage.PADDING, 2));
            vertexformat.func_181721_a(new VertexFormatElement(lightmap ? 1 : 0, VertexFormatElement.EnumType.SHORT, lightmap ? VertexFormatElement.EnumUsage.UV : VertexFormatElement.EnumUsage.PADDING, 2));
            vertexformat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.BYTE, normal ? VertexFormatElement.EnumUsage.NORMAL : VertexFormatElement.EnumUsage.PADDING, 3));
            vertexformat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.BYTE, VertexFormatElement.EnumUsage.PADDING, 1));
            if (entityAttrib != -1) {
                if (velocityAttrib != -1) {
                    vertexformat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.BYTE, VertexFormatElement.EnumUsage.PADDING, 4));
                }
                vertexformat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.PADDING, 2));
                vertexformat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.SHORT, VertexFormatElement.EnumUsage.PADDING, 4));
                vertexformat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.SHORT, VertexFormatElement.EnumUsage.PADDING, 4));
                if (velocityAttrib != -1) {
                    vertexformat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.PADDING, 3));
                }
            }
            VertexBuilder.cache[index] = vertexformat;
        }
        return cache[index];
    }

    public static void fillEntity(BufferBuilder builder, int x, int y, int z) {
        if (builder.func_178973_g().func_177338_f() != (velocityAttrib == -1 ? 56 : 72)) {
            return;
        }
        int baseIndex = (builder.func_178989_h() - 1) * builder.func_178973_g().func_181719_f();
        if (baseIndex < 0) {
            return;
        }
        ByteBuffer byteBuf = builder.func_178966_f();
        int pos = byteBuf.position();
        byteBuf.position(0);
        int offset = velocityAttrib == -1 ? 12 : 13;
        IntBuffer buffer = builder.func_178966_f().asIntBuffer();
        int i = (y & 0xFFFF) << 16 | x & 0xFFFF;
        int j = z & 0xFFFF;
        buffer.put(baseIndex + offset, i);
        buffer.put(baseIndex + offset + 1, j);
    }

    public static void fillMidTexCoord(BufferBuilder builder, float u, float v) {
        if (builder.func_178973_g().func_177338_f() != (velocityAttrib == -1 ? 56 : 72)) {
            return;
        }
        int baseIndex = (builder.func_178989_h() - 1) * builder.func_178973_g().func_181719_f();
        if (baseIndex < 0) {
            return;
        }
        ByteBuffer byteBuf = builder.func_178966_f();
        int pos = byteBuf.position();
        byteBuf.position(0);
        int offset = velocityAttrib == -1 ? 8 : 9;
        FloatBuffer buffer = builder.func_178966_f().asFloatBuffer();
        byteBuf.position(pos);
        buffer.put(baseIndex + offset, u);
        buffer.put(baseIndex + offset + 1, v);
    }

    public static void resetNormal(BufferBuilder builder, float x, float y, float z) {
        int vertexCount;
        if (builder.func_178979_i() != 7 || !builder.func_178973_g().func_177350_b() || builder.func_178973_g().func_177338_f() != (velocityAttrib == -1 ? 56 : 72)) {
            return;
        }
        int n = vertexCount = builder.func_178979_i() == 7 ? 4 : 3;
        if (builder.func_178989_h() % vertexCount != 0) {
            return;
        }
        int vertexSize = builder.func_178973_g().func_177338_f();
        int normalOffset = builder.func_178973_g().func_177342_c();
        int baseIndex = (builder.func_178989_h() - vertexCount) * vertexSize;
        ByteBuffer byteBuf = builder.func_178966_f();
        int pos = byteBuf.position();
        byteBuf.position(0);
        float lenSquared = x * x + y * y + z * z;
        if (lenSquared > 1.0E-4f) {
            x = (float)((double)x / Math.sqrt(lenSquared));
            y = (float)((double)y / Math.sqrt(lenSquared));
            z = (float)((double)z / Math.sqrt(lenSquared));
        }
        for (int i = 0; i < vertexCount; ++i) {
            byteBuf.put(baseIndex + vertexSize * i + normalOffset + 0, (byte)((int)(x * 127.0f) & 0xFF));
            byteBuf.put(baseIndex + vertexSize * i + normalOffset + 1, (byte)((int)(y * 127.0f) & 0xFF));
            byteBuf.put(baseIndex + vertexSize * i + normalOffset + 2, (byte)((int)(z * 127.0f) & 0xFF));
        }
        byteBuf.position(pos);
    }

    public static void calcTangent(BufferBuilder builder, boolean calcNormal) {
        int vertexCount;
        if (builder.func_178979_i() != 7 && builder.func_178979_i() != 4 || !builder.func_178973_g().func_177350_b() || builder.func_178973_g().func_177338_f() != (velocityAttrib == -1 ? 56 : 72)) {
            return;
        }
        int n = vertexCount = builder.func_178979_i() == 7 ? 4 : 3;
        if (builder.func_178989_h() % vertexCount != 0) {
            return;
        }
        int vertexSize = builder.func_178973_g().func_181719_f();
        int normalOffset = builder.func_178973_g().func_177342_c() / 4;
        int baseIndex = (builder.func_178989_h() - vertexCount) * vertexSize;
        ByteBuffer byteBuf = builder.func_178966_f();
        int pos = byteBuf.position();
        byteBuf.position(0);
        IntBuffer intBuf = builder.func_178966_f().asIntBuffer();
        FloatBuffer floatBuf = builder.func_178966_f().asFloatBuffer();
        byteBuf.position(pos);
        Point3f v0 = new Point3f();
        Point3f v1 = new Point3f();
        Point3f v2 = new Point3f();
        v0.x = floatBuf.get(baseIndex + vertexSize * 0 + 0);
        v0.y = floatBuf.get(baseIndex + vertexSize * 0 + 1);
        v0.z = floatBuf.get(baseIndex + vertexSize * 0 + 2);
        v1.x = floatBuf.get(baseIndex + vertexSize * 1 + 0);
        v1.y = floatBuf.get(baseIndex + vertexSize * 1 + 1);
        v1.z = floatBuf.get(baseIndex + vertexSize * 1 + 2);
        v2.x = floatBuf.get(baseIndex + vertexSize * 2 + 0);
        v2.y = floatBuf.get(baseIndex + vertexSize * 2 + 1);
        v2.z = floatBuf.get(baseIndex + vertexSize * 2 + 2);
        Vector3f e1 = new Vector3f();
        Vector3f e2 = new Vector3f();
        e1.sub((Tuple3f)v1, (Tuple3f)v0);
        e2.sub((Tuple3f)v2, (Tuple3f)v0);
        if (calcNormal) {
            Vector3f normal = new Vector3f();
            normal.cross(e1, e2);
            if (normal.lengthSquared() > 1.0E-4f) {
                normal.normalize();
            } else {
                normal.set(0.0f, 0.0f, 1.0f);
            }
            int packedNormal = ((int)(normal.z * 127.0f) & 0xFF) << 16 | ((int)(normal.y * 127.0f) & 0xFF) << 8 | (int)(normal.x * 127.0f) & 0xFF;
            intBuf.put(baseIndex + vertexSize * 0 + normalOffset, packedNormal);
            intBuf.put(baseIndex + vertexSize * 1 + normalOffset, packedNormal);
            intBuf.put(baseIndex + vertexSize * 2 + normalOffset, packedNormal);
        }
        if (!builder.func_178973_g().func_177347_a(0)) {
            return;
        }
        int uvOffset = builder.func_178973_g().func_177344_b(0) / 4;
        int tangentOffset = velocityAttrib == -1 ? 10 : 11;
        Point2f uv0 = new Point2f();
        Point2f uv1 = new Point2f();
        Point2f uv2 = new Point2f();
        uv0.x = floatBuf.get(baseIndex + vertexSize * 0 + uvOffset + 0);
        uv0.y = floatBuf.get(baseIndex + vertexSize * 0 + uvOffset + 1);
        uv1.x = floatBuf.get(baseIndex + vertexSize * 1 + uvOffset + 0);
        uv1.y = floatBuf.get(baseIndex + vertexSize * 1 + uvOffset + 1);
        uv2.x = floatBuf.get(baseIndex + vertexSize * 2 + uvOffset + 0);
        uv2.y = floatBuf.get(baseIndex + vertexSize * 2 + uvOffset + 1);
        Vector2f duv1 = new Vector2f();
        Vector2f duv2 = new Vector2f();
        duv1.sub((Tuple2f)uv1, (Tuple2f)uv0);
        duv2.sub((Tuple2f)uv2, (Tuple2f)uv0);
        Vector3f tangent = new Vector3f();
        Vector3f binormal = new Vector3f();
        float scale = duv1.y * duv2.x - duv1.x * duv2.y;
        if (Math.abs(scale) <= 1.0E-4f) {
            scale = 1.0f;
        }
        tangent.scale(duv1.y, (Tuple3f)e2);
        tangent.scaleAdd(-duv2.y, (Tuple3f)e1, (Tuple3f)tangent);
        tangent.scale(1.0f / scale);
        binormal.scale(duv2.x, (Tuple3f)e1);
        binormal.scaleAdd(-duv1.x, (Tuple3f)e2, (Tuple3f)binormal);
        binormal.scale(1.0f / scale);
        if (tangent.lengthSquared() > 1.0E-4f) {
            tangent.normalize();
        }
        if (binormal.lengthSquared() > 1.0E-4f) {
            binormal.normalize();
        }
        int packedNormal = intBuf.get(baseIndex + vertexSize * 0 + normalOffset);
        Vector3f normal = new Vector3f();
        normal.x = (byte)packedNormal;
        normal.y = (byte)(packedNormal >> 8);
        normal.z = (byte)(packedNormal >> 16);
        if (normal.lengthSquared() <= 1.0E-4f) {
            normal.cross(e1, e2);
        }
        normal.normalize();
        Vector3f binormalCheck = new Vector3f();
        binormalCheck.cross(normal, tangent);
        float w = binormalCheck.dot(binormal) < 0.0f ? -1.0f : 1.0f;
        tangent.scaleAdd(-normal.dot(tangent), (Tuple3f)normal, (Tuple3f)tangent);
        if (tangent.lengthSquared() > 1.0E-4f) {
            tangent.normalize();
        }
        int p1 = ((int)(tangent.y * 32767.0f) & 0xFFFF) << 16 | (int)(tangent.x * 32767.0f) & 0xFFFF;
        int p2 = ((int)(w * 32767.0f) & 0xFFFF) << 16 | (int)(tangent.z * 32767.0f) & 0xFFFF;
        for (int i = 0; i < vertexCount; ++i) {
            intBuf.put(baseIndex + vertexSize * i + tangentOffset + 0, p1);
            intBuf.put(baseIndex + vertexSize * i + tangentOffset + 1, p2);
        }
    }

    public static Vector4f calcTangent(Point3f[] vertices, Point2f[] uvs, Vector3f normal) {
        Point3f v0 = vertices[0];
        Point3f v1 = vertices[1];
        Point3f v2 = vertices[2];
        Vector3f e1 = new Vector3f();
        Vector3f e2 = new Vector3f();
        e1.sub((Tuple3f)v1, (Tuple3f)v0);
        e2.sub((Tuple3f)v2, (Tuple3f)v0);
        Point2f uv0 = uvs[0];
        Point2f uv1 = uvs[1];
        Point2f uv2 = uvs[2];
        Vector2f duv1 = new Vector2f();
        Vector2f duv2 = new Vector2f();
        duv1.sub((Tuple2f)uv1, (Tuple2f)uv0);
        duv2.sub((Tuple2f)uv2, (Tuple2f)uv0);
        Vector3f tangent = new Vector3f();
        Vector3f binormal = new Vector3f();
        float scale = duv1.y * duv2.x - duv1.x * duv2.y;
        if (Math.abs(scale) <= 1.0E-4f) {
            scale = 1.0f;
        }
        tangent.scale(duv1.y, (Tuple3f)e2);
        tangent.scaleAdd(-duv2.y, (Tuple3f)e1, (Tuple3f)tangent);
        tangent.scale(1.0f / scale);
        binormal.scale(duv2.x, (Tuple3f)e1);
        binormal.scaleAdd(-duv1.x, (Tuple3f)e2, (Tuple3f)binormal);
        binormal.scale(1.0f / scale);
        if (tangent.lengthSquared() > 1.0E-4f) {
            tangent.normalize();
        }
        if (binormal.lengthSquared() > 1.0E-4f) {
            binormal.normalize();
        }
        if (normal.lengthSquared() <= 1.0E-4f) {
            normal.cross(e1, e2);
        }
        normal.normalize();
        Vector3f binormalCheck = new Vector3f();
        binormalCheck.cross(normal, tangent);
        float w = binormalCheck.dot(binormal) < 0.0f ? -1.0f : 1.0f;
        tangent.scaleAdd(-normal.dot(tangent), (Tuple3f)normal, (Tuple3f)tangent);
        if (tangent.lengthSquared() > 1.0E-4f) {
            tangent.normalize();
        }
        return new Vector4f(tangent.x, tangent.y, tangent.z, w);
    }

    public static void fillVelocity(BufferBuilder builder, float x, float y, float z) {
        if (velocityAttrib == -1 || builder.func_178973_g().func_177338_f() != 72) {
            return;
        }
        int baseIndex = (builder.func_178989_h() - 1) * builder.func_178973_g().func_181719_f();
        if (baseIndex < 0) {
            return;
        }
        ByteBuffer byteBuf = builder.func_178966_f();
        int pos = byteBuf.position();
        byteBuf.position(0);
        int offset = 15;
        FloatBuffer buffer = builder.func_178966_f().asFloatBuffer();
        byteBuf.position(pos);
        buffer.put(baseIndex + offset, x);
        buffer.put(baseIndex + offset + 1, y);
        buffer.put(baseIndex + offset + 2, z);
    }

    public static void fillMidBlock(BufferBuilder builder, int x, int y, int z) {
        if (velocityAttrib == -1 || builder.func_178973_g().func_177338_f() != 72) {
            return;
        }
        int baseIndex = (builder.func_178989_h() - 1) * builder.func_178973_g().func_181719_f();
        if (baseIndex < 0) {
            return;
        }
        ByteBuffer byteBuf = builder.func_178966_f();
        int pos = byteBuf.position();
        byteBuf.position(0);
        int offset = 8;
        IntBuffer buffer = builder.func_178966_f().asIntBuffer();
        byteBuf.position(pos);
        buffer.put(baseIndex + offset, x);
        buffer.put(baseIndex + offset + 1, y);
        buffer.put(baseIndex + offset + 2, z);
    }

    static {
        try {
            Class<?> clazz = Class.forName("net.optifine.shaders.Shaders");
            Field fieldEntity = clazz.getField("entityAttrib");
            Field fieldMidTexCoord = clazz.getField("midTexCoordAttrib");
            Field fieldTangent = clazz.getField("tangentAttrib");
            entityAttrib = fieldEntity.getInt(null);
            midTexCoordAttrib = fieldMidTexCoord.getInt(null);
            tangentAttrib = fieldTangent.getInt(null);
            Field fieldVelocity = clazz.getField("velocityAttrib");
            Field fieldMidBlock = clazz.getField("midBlockAttrib");
            velocityAttrib = fieldVelocity.getInt(null);
            midBlockAttrib = fieldMidBlock.getInt(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
    }
}

