/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.utils.resizers;

import java.util.function.Supplier;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.client.gui.utils.resizers.constraint.BoundsResizer;
import mchorse.mclib.client.gui.utils.resizers.layout.ColumnResizer;
import mchorse.mclib.client.gui.utils.resizers.layout.GridResizer;
import mchorse.mclib.client.gui.utils.resizers.layout.RowResizer;

public class Flex
implements IResizer {
    public Unit x = new Unit();
    public Unit y = new Unit();
    public Unit w = new Unit();
    public Unit h = new Unit();
    public IResizer relative;
    public IResizer post;
    public final GuiElement parent;

    public Flex(GuiElement parent) {
        this.parent = parent;
    }

    public Flex reset() {
        this.x = new Unit();
        this.y = new Unit();
        this.w = new Unit();
        this.h = new Unit();
        this.post = null;
        this.relative = null;
        return this;
    }

    public void link(Flex flex) {
        this.x = flex.x;
        this.y = flex.y;
        this.w = flex.w;
        this.h = flex.h;
        this.relative = flex.relative;
        this.post = flex.post;
    }

    public Flex set(float x, float y, float w, float h) {
        return this.set(x, y, w, h, Measure.PIXELS);
    }

    public Flex set(float x, float y, float w, float h, Measure measure) {
        this.x.set(x, measure);
        this.y.set(y, measure);
        this.w.set(w, measure);
        this.h.set(h, measure);
        return this;
    }

    public Flex x(int value) {
        this.x.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Flex x(float value) {
        this.x.set(value, Measure.RELATIVE);
        return this;
    }

    public Flex x(float value, int offset) {
        this.x.set(value, Measure.RELATIVE, offset);
        return this;
    }

    public Flex x(Supplier<Float> value) {
        this.x.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Flex x(Supplier<Float> value, int offset) {
        this.x.set(value, Measure.PIXELS, offset);
        return this;
    }

    public Flex y(int value) {
        this.y.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Flex y(float value) {
        this.y.set(value, Measure.RELATIVE, 0);
        return this;
    }

    public Flex y(float value, int offset) {
        this.y.set(value, Measure.RELATIVE, offset);
        return this;
    }

    public Flex y(Supplier<Float> value) {
        this.y.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Flex y(Supplier<Float> value, int offset) {
        this.y.set(value, Measure.PIXELS, offset);
        return this;
    }

    public Flex w(int value) {
        this.w.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Flex w(float value) {
        this.w.set(value, Measure.RELATIVE, 0);
        return this;
    }

    public Flex w(float value, int offset) {
        this.w.set(value, Measure.RELATIVE, offset);
        return this;
    }

    public Flex w(Supplier<Float> value) {
        this.w.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Flex w(Supplier<Float> value, int offset) {
        this.w.set(value, Measure.PIXELS, offset);
        return this;
    }

    public Flex wTo(IResizer flex) {
        this.w.target = flex;
        return this;
    }

    public Flex wTo(IResizer flex, int offset) {
        this.w.target = flex;
        this.w.offset = offset;
        return this;
    }

    public Flex wTo(IResizer flex, float anchor) {
        this.w.target = flex;
        this.w.targetAnchor = anchor;
        return this;
    }

    public Flex wTo(IResizer flex, float anchor, int offset) {
        this.w.target = flex;
        this.w.targetAnchor = anchor;
        this.w.offset = offset;
        return this;
    }

    public Flex h(int value) {
        this.h.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Flex h(float value) {
        this.h.set(value, Measure.RELATIVE, 0);
        return this;
    }

    public Flex h(float value, int offset) {
        this.h.set(value, Measure.RELATIVE, offset);
        return this;
    }

    public Flex h(Supplier<Float> value) {
        this.h.set(value, Measure.PIXELS, 0);
        return this;
    }

    public Flex h(Supplier<Float> value, int offset) {
        this.h.set(value, Measure.PIXELS, offset);
        return this;
    }

    public Flex hTo(IResizer target) {
        return this.hTo(target, 0);
    }

    public Flex hTo(IResizer target, int offset) {
        return this.hTo(target, 0.0f, offset);
    }

    public Flex hTo(IResizer target, float anchor) {
        return this.hTo(target, anchor, 0);
    }

    public Flex hTo(IResizer target, float anchor, int offset) {
        this.h.target = target;
        this.h.targetAnchor = anchor;
        this.h.offset = offset;
        return this;
    }

    public Flex xy(int x, int y) {
        this.x.set(x, Measure.PIXELS);
        this.y.set(y, Measure.PIXELS);
        return this;
    }

    public Flex xy(float x, float y) {
        this.x.set(x, Measure.RELATIVE);
        this.y.set(y, Measure.RELATIVE);
        return this;
    }

    public Flex wh(int w, int h) {
        this.w.set(w, Measure.PIXELS);
        this.h.set(h, Measure.PIXELS);
        return this;
    }

    public Flex wh(float w, float h) {
        this.w.set(w, Measure.RELATIVE);
        this.h.set(h, Measure.RELATIVE);
        return this;
    }

    public Flex maxW(int max) {
        this.w.max = max;
        return this;
    }

    public Flex maxH(int max) {
        this.h.max = max;
        return this;
    }

    public Flex anchor(float x, float y) {
        this.x.anchor = x;
        this.y.anchor = y;
        return this;
    }

    public Flex anchorX(float x) {
        this.x.anchor = x;
        return this;
    }

    public Flex anchorY(float y) {
        this.y.anchor = y;
        return this;
    }

    public Flex above(Flex flex, int offset) {
        return this.relative(flex).y(0.0f, offset).anchorY(1.0f);
    }

    public Flex under(Flex flex, int offset) {
        return this.relative(flex).y(1.0f, offset);
    }

    public Flex left(Flex flex, int offset) {
        return this.relative(flex).x(0.0f, offset).anchorX(1.0f);
    }

    public Flex right(Flex flex, int offset) {
        return this.relative(flex).x(1.0f, offset);
    }

    public RowResizer row(int margin) {
        if (this.post instanceof RowResizer) {
            return (RowResizer)this.post;
        }
        return RowResizer.apply(this.parent, margin);
    }

    public ColumnResizer column(int margin) {
        if (this.post instanceof ColumnResizer) {
            return (ColumnResizer)this.post;
        }
        return ColumnResizer.apply(this.parent, margin);
    }

    public GridResizer grid(int margin) {
        if (this.post instanceof GridResizer) {
            return (GridResizer)this.post;
        }
        return GridResizer.apply(this.parent, margin);
    }

    public BoundsResizer bounds(GuiElement target, int margin) {
        if (this.post instanceof BoundsResizer) {
            return (BoundsResizer)this.post;
        }
        return BoundsResizer.apply(this.parent, target, margin);
    }

    public Flex relative(GuiElement element) {
        this.relative = element.area;
        return this;
    }

    public Flex relative(IResizer relative) {
        this.relative = relative;
        return this;
    }

    public Flex post(IResizer post) {
        this.post = post;
        return this;
    }

    @Override
    public void preApply(Area area) {
    }

    @Override
    public void apply(Area area) {
        if (this.post != null) {
            this.post.preApply(area);
        }
        area.w = this.getW();
        area.h = this.getH();
        area.x = this.getX();
        area.y = this.getY();
        if (this.post != null) {
            this.post.apply(area);
        }
    }

    @Override
    public void postApply(Area area) {
        if (this.post != null) {
            this.post.postApply(area);
        }
    }

    @Override
    public void add(GuiElement parent, GuiElement child) {
        if (this.post != null) {
            this.post.add(parent, child);
        }
    }

    @Override
    public void remove(GuiElement parent, GuiElement child) {
        if (this.post != null) {
            this.post.remove(parent, child);
        }
    }

    @Override
    public int getX() {
        int value = (int)this.x.getValue();
        if (this.relative != null) {
            value += this.relative.getX();
            if (this.x.unit == Measure.RELATIVE) {
                value = this.relative.getX() + (int)((float)this.relative.getW() * this.x.getValue());
            }
        }
        value += this.x.offset;
        if (this.x.anchor != 0.0f) {
            value = (int)((float)value - this.x.anchor * (float)this.getW());
        }
        return value;
    }

    @Override
    public int getY() {
        int value = (int)this.y.getValue();
        if (this.relative != null) {
            value += this.relative.getY();
            if (this.y.unit == Measure.RELATIVE) {
                value = this.relative.getY() + (int)((float)this.relative.getH() * this.y.getValue());
            }
        }
        value += this.y.offset;
        if (this.y.anchor != 0.0f) {
            value = (int)((float)value - this.y.anchor * (float)this.getH());
        }
        return value;
    }

    @Override
    public int getW() {
        int value;
        if (this.w.target != null) {
            int w = this.w.targetAnchor == 0.0f ? 0 : (int)((float)this.w.target.getW() * this.w.targetAnchor);
            return this.w.normalize(this.w.target.getX() + w - this.getX() + this.w.offset);
        }
        int n = value = this.post == null ? 0 : this.post.getW();
        if (value != 0) {
            return value;
        }
        value = (int)this.w.getValue();
        if (this.relative != null && this.w.unit == Measure.RELATIVE) {
            value = (int)((float)this.relative.getW() * this.w.getValue());
        }
        value += this.w.offset;
        if (this.w.max > 0) {
            value = Math.min(value, this.w.max);
        }
        return value;
    }

    @Override
    public int getH() {
        int value;
        if (this.h.target != null) {
            int h = this.h.targetAnchor == 0.0f ? 0 : (int)((float)this.h.target.getH() * this.h.targetAnchor);
            return this.h.normalize(this.h.target.getY() + h - this.getY() + this.h.offset);
        }
        int n = value = this.post == null ? 0 : this.post.getH();
        if (value != 0) {
            return value;
        }
        value = (int)this.h.getValue();
        if (this.relative != null && this.h.unit == Measure.RELATIVE) {
            value = (int)((float)this.relative.getH() * this.h.getValue());
        }
        value += this.h.offset;
        if (this.h.max > 0) {
            value = Math.min(value, this.h.max);
        }
        return value;
    }

    public static enum Measure {
        PIXELS,
        RELATIVE;

    }

    public static class Unit {
        private float value;
        private Supplier<Float> valueConsumer;
        public int offset;
        public int max;
        public float anchor;
        public Measure unit = Measure.PIXELS;
        public IResizer target;
        public float targetAnchor;

        public void set(Supplier<Float> value, Measure unit) {
            this.set(value, unit, 0);
        }

        public void set(Supplier<Float> value, Measure unit, int offset) {
            this.valueConsumer = value;
            this.unit = unit;
            this.offset = offset;
            this.value = 0.0f;
            this.target = null;
            this.targetAnchor = 0.0f;
        }

        public void set(float value, Measure unit) {
            this.set(value, unit, 0);
        }

        public void set(float value, Measure unit, int offset) {
            this.value = value;
            this.unit = unit;
            this.offset = offset;
            this.target = null;
            this.targetAnchor = 0.0f;
        }

        public float getValue() {
            return this.valueConsumer == null ? this.value : this.valueConsumer.get().floatValue();
        }

        public int normalize(int value) {
            return this.max > 0 ? Math.min(value, this.max) : value;
        }
    }
}

