/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.utils.keys;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import mchorse.mclib.client.gui.utils.keys.CompoundKey;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.keys.LangKey;
import mchorse.mclib.client.gui.utils.keys.StringKey;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class KeyParser {
    public static final Gson JSON_PARSER = new GsonBuilder().registerTypeHierarchyAdapter(IKey.class, (Object)new KeyJsonAdapter()).serializeNulls().create();

    public static IKey keyFromBytes(ByteBuf buffer) {
        byte type = buffer.readByte();
        if (type == 0) {
            return IKey.str(ByteBufUtils.readUTF8String((ByteBuf)buffer));
        }
        if (type == 1) {
            String key = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            ArrayList<Object> args = new ArrayList<Object>();
            int c = buffer.readInt();
            for (int i = 0; i < c; ++i) {
                byte argType = buffer.readByte();
                if (argType == 0) {
                    args.add(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                    continue;
                }
                if (argType != 1) continue;
                args.add(KeyParser.keyFromBytes(buffer));
            }
            return args.isEmpty() ? IKey.lang(key) : IKey.format(key, args.toArray(new Object[args.size()]));
        }
        if (type == 2) {
            ArrayList<IKey> keys = new ArrayList<IKey>();
            int c = buffer.readInt();
            for (int i = 0; i < c; ++i) {
                IKey key = KeyParser.keyFromBytes(buffer);
                if (key == null) continue;
                keys.add(key);
            }
            return IKey.comp(keys.toArray(new IKey[keys.size()]));
        }
        return null;
    }

    public static void keyToBytes(ByteBuf buffer, IKey key) {
        if (key instanceof StringKey) {
            buffer.writeByte(0);
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((StringKey)key).string);
        } else if (key instanceof LangKey) {
            LangKey lang = (LangKey)key;
            buffer.writeByte(1);
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)lang.key);
            buffer.writeInt(lang.args.length);
            for (Object arg : lang.args) {
                if (arg instanceof String) {
                    buffer.writeByte(0);
                    ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((String)arg));
                    continue;
                }
                if (arg instanceof IKey) {
                    buffer.writeByte(1);
                    KeyParser.keyToBytes(buffer, (IKey)arg);
                    continue;
                }
                buffer.writeByte(0);
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)arg.toString());
            }
        } else if (key instanceof CompoundKey) {
            CompoundKey compound = (CompoundKey)key;
            buffer.writeByte(2);
            buffer.writeInt(compound.keys.length);
            for (IKey childKey : compound.keys) {
                KeyParser.keyToBytes(buffer, childKey);
            }
        } else {
            buffer.writeByte(100);
        }
    }

    public static IKey fromJson(String json) {
        IKey key = (IKey)JSON_PARSER.fromJson(json, IKey.class);
        if (key == null) {
            key = IKey.EMPTY;
        }
        return key;
    }

    public static String toJson(IKey key) {
        if (key == null || IKey.EMPTY.equals(key)) {
            return "";
        }
        return JSON_PARSER.toJson((Object)key);
    }

    public static class KeyJsonAdapter
    implements JsonDeserializer<IKey>,
    JsonSerializer<IKey> {
        public JsonElement serialize(IKey src, Type typeOfSrc, JsonSerializationContext context) {
            if (src instanceof LangKey) {
                LangKey lang = (LangKey)src;
                JsonObject obj = new JsonObject();
                JsonArray arr = new JsonArray();
                for (Object arg : lang.args) {
                    arr.add(context.serialize(arg));
                }
                obj.add(lang.key, (JsonElement)arr);
                return obj;
            }
            if (src instanceof CompoundKey) {
                CompoundKey compound = (CompoundKey)src;
                JsonArray arr = new JsonArray();
                for (IKey key : compound.keys) {
                    arr.add(context.serialize((Object)key, IKey.class));
                }
                return arr;
            }
            return new JsonPrimitive(String.valueOf(src));
        }

        public IKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                String key = (String)((Map.Entry)obj.entrySet().iterator().next()).getKey();
                LangKey lang = new LangKey(key);
                JsonElement element = obj.get(key);
                if (element instanceof JsonArray) {
                    ArrayList<Object> args = new ArrayList<Object>();
                    Iterator iterator = element.getAsJsonArray().iterator();
                    while (iterator.hasNext()) {
                        JsonElement child;
                        args.add(context.deserialize(child, (child = (JsonElement)iterator.next()).isJsonPrimitive() ? Object.class : IKey.class));
                    }
                    lang.args = args.toArray();
                }
                return lang;
            }
            if (json.isJsonArray()) {
                JsonArray arr = json.getAsJsonArray();
                CompoundKey compound = new CompoundKey(new IKey[0]);
                ArrayList<Object> keys = new ArrayList<Object>();
                for (JsonElement key : arr) {
                    keys.add(context.deserialize(key, IKey.class));
                }
                compound.keys = keys.toArray(new IKey[0]);
                return compound;
            }
            if (json.isJsonNull()) {
                return IKey.EMPTY;
            }
            return new StringKey(json.toString());
        }
    }
}

