/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.utils;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.ITextColoring;
import mchorse.mclib.client.gui.framework.elements.utils.IconContainer;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class GuiLabel
extends GuiElement
implements ITextColoring {
    public IKey label;
    public int color;
    public boolean textShadow = true;
    public float anchorX;
    public float anchorY;
    public int background;
    public Supplier<Integer> backgroundColor;
    private IconContainer leftIcon;
    private IconContainer rightIcon;

    public GuiLabel(Minecraft mc, IKey label) {
        this(mc, label, 0xFFFFFF);
    }

    public GuiLabel(Minecraft mc, IKey label, int color) {
        this(mc, label, 0xFFFFFF, (IconContainer)null, null);
    }

    public GuiLabel(Minecraft mc, IKey label, int color, @Nullable Icon leftIcon, @Nullable Icon rightIcon) {
        super(mc);
        this.label = label;
        this.color = color;
        this.leftIcon = leftIcon != null ? new IconContainer(leftIcon) : null;
        this.rightIcon = rightIcon != null ? new IconContainer(rightIcon) : null;
    }

    public GuiLabel(Minecraft mc, IKey label, int color, @Nullable IconContainer leftIcon, @Nullable IconContainer rightIcon) {
        super(mc);
        this.label = label;
        this.color = color;
        this.leftIcon = leftIcon;
        this.rightIcon = rightIcon;
    }

    public GuiLabel(Minecraft mc, IKey label, @Nullable Icon leftIcon, @Nullable Icon rightIcon) {
        this(mc, label, 0xFFFFFF, leftIcon, rightIcon);
    }

    public IconContainer getLeftIcon() {
        return this.leftIcon;
    }

    public void setLeftIcon(Icon leftIcon) {
        if (this.leftIcon != null) {
            this.leftIcon.setIcon(leftIcon);
        } else {
            this.leftIcon = new IconContainer(leftIcon);
        }
    }

    public IconContainer getRightIcon() {
        return this.rightIcon;
    }

    public void setRightIcon(Icon rightIcon) {
        if (this.rightIcon != null) {
            this.rightIcon.setIcon(rightIcon);
        } else {
            this.rightIcon = new IconContainer(rightIcon);
        }
    }

    public void setRightIconContainer(IconContainer rightIcon) {
        this.rightIcon = rightIcon;
    }

    public void setLeftIconContainer(IconContainer leftIcon) {
        this.leftIcon = leftIcon;
    }

    @Override
    public void setColor(int color, boolean shadow) {
        this.color(color, shadow);
    }

    public GuiLabel color(int color) {
        return this.color(color, true);
    }

    public GuiLabel color(int color, boolean textShadow) {
        this.textShadow = textShadow;
        this.color = color;
        return this;
    }

    public GuiLabel background() {
        return this.background(-2013265920);
    }

    public GuiLabel background(int color) {
        this.background = color;
        return this;
    }

    public GuiLabel background(Supplier<Integer> color) {
        this.backgroundColor = color;
        return this;
    }

    public GuiLabel anchor(float x, float y) {
        this.anchorX = x;
        this.anchorY = y;
        return this;
    }

    public int getColor() {
        return this.backgroundColor == null ? this.background : this.backgroundColor.get();
    }

    @Override
    public void draw(GuiContext context) {
        int offset = 3;
        int leftIconW = this.leftIcon != null ? this.leftIcon.getW() : 0;
        int rightIconW = this.rightIcon != null ? this.rightIcon.getW() : 0;
        int textWidth = this.font.func_78256_a(this.label.get());
        int width = textWidth + rightIconW + leftIconW;
        int x0 = this.area.x(this.anchorX, width);
        int x1 = x0 + width;
        int y = this.area.y(this.anchorY, this.font.field_78288_b);
        int xText = x0 + leftIconW;
        int a = this.getColor() >> 24 & 0xFF;
        if (a != 0) {
            Gui.func_73734_a((int)x0, (int)(y - offset), (int)(x1 + 2 * offset), (int)(y + this.font.field_78288_b), (int)this.getColor());
            x0 += offset;
            xText += offset;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.leftIcon != null) {
            this.leftIcon.render(x0, y, 0.5f, 0.5f);
        }
        if (this.rightIcon != null) {
            this.rightIcon.render(xText + textWidth, y, 0.5f, 0.5f);
        }
        this.font.func_175065_a(this.label.get(), (float)xText, (float)y, this.color, this.textShadow);
        super.draw(context);
    }
}

