/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.keyframes;

import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiSheet;
import mchorse.mclib.client.gui.framework.elements.keyframes.IAxisConverter;
import mchorse.mclib.client.gui.framework.elements.keyframes.Selection;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Scale;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.keyframes.Keyframe;
import mchorse.mclib.utils.keyframes.KeyframeEasing;
import mchorse.mclib.utils.keyframes.KeyframeInterpolation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;

public abstract class GuiKeyframeElement
extends GuiElement {
    public static final Color COLOR = new Color();
    public Consumer<Keyframe> callback;
    public Selection which = Selection.NOT_SELECTED;
    public int duration;
    public double minZoom = 0.01;
    public double maxZoom = 1000.0;
    public boolean sliding;
    public boolean dragging;
    protected boolean moving;
    protected boolean scrolling;
    protected boolean grabbing;
    protected int lastX;
    protected int lastY;
    protected double lastT;
    protected double lastV;
    protected Scale scaleX;
    protected IAxisConverter converter;

    public GuiKeyframeElement(Minecraft mc, Consumer<Keyframe> callback) {
        super(mc);
        this.callback = callback;
        this.scaleX = new Scale(this.area, false);
        this.scaleX.anchor(0.5f);
    }

    public void setConverter(IAxisConverter converter) {
        this.converter = converter;
    }

    public Scale getScaleX() {
        return this.scaleX;
    }

    protected void setKeyframe(Keyframe current) {
        if (this.callback != null) {
            this.callback.accept(current);
        }
    }

    public abstract void setTick(double var1, boolean var3);

    public abstract void setValue(double var1, boolean var3);

    public abstract void setInterpolation(KeyframeInterpolation var1);

    public abstract void setEasing(KeyframeEasing var1);

    public void setDuration(long duration) {
        this.duration = (int)duration;
    }

    public abstract void resetView();

    public int toGraphX(double tick) {
        return (int)this.scaleX.to(tick);
    }

    public double fromGraphX(int mouseX) {
        return this.scaleX.from(mouseX);
    }

    public abstract Keyframe getCurrent();

    public abstract List<GuiSheet> getSheets();

    public abstract GuiSheet getSheet(int var1);

    public boolean isGrabbing() {
        return this.dragging && this.moving && this.grabbing;
    }

    public void selectByDuration(long duration) {
    }

    public abstract void selectAll();

    public abstract int getSelectedCount();

    public boolean isMultipleSelected() {
        return this.getSelectedCount() > 1;
    }

    public boolean hasSelected() {
        return this.getSelectedCount() > 0;
    }

    public abstract void clearSelection();

    public void doubleClick(int mouseX, int mouseY) {
        if (this.which == Selection.NOT_SELECTED) {
            this.addCurrent(mouseX, mouseY);
        } else if (this.which == Selection.KEYFRAME && !this.isMultipleSelected()) {
            this.removeCurrent();
        }
    }

    public abstract void addCurrent(int var1, int var2);

    public abstract void removeCurrent();

    public abstract void removeSelectedKeyframes();

    protected void updateMoved() {
    }

    protected void moveNoKeyframe(GuiContext context, Keyframe frame, double x, double y) {
    }

    protected void drawCursor(GuiContext context) {
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        if (this.area.isInside(mouseX, mouseY)) {
            if (context.mouseButton == 0) {
                boolean shift = GuiScreen.func_146272_n();
                if (GuiScreen.func_175283_s() && !shift && this.which == Selection.KEYFRAME) {
                    this.duplicateKeyframe(context, mouseX, mouseY);
                    return false;
                }
                this.lastX = mouseX;
                this.lastY = mouseY;
                if (shift) {
                    this.grabbing = true;
                }
                if (!this.pickKeyframe(context, mouseX, mouseY, shift) && !shift) {
                    this.clearSelection();
                    this.setKeyframe(null);
                }
                this.dragging = true;
                this.pickedKeyframe(this.getSelectedCount());
            } else if (context.mouseButton == 2) {
                this.setupScrolling(context, mouseX, mouseY);
            }
        }
        return false;
    }

    protected void pickedKeyframe(int amount) {
    }

    protected abstract void duplicateKeyframe(GuiContext var1, int var2, int var3);

    protected abstract boolean pickKeyframe(GuiContext var1, int var2, int var3, boolean var4);

    protected void setupScrolling(GuiContext context, int mouseX, int mouseY) {
        this.scrolling = true;
        this.lastX = mouseX;
        this.lastY = mouseY;
        this.lastT = this.scaleX.getShift();
    }

    @Override
    public boolean mouseScrolled(GuiContext context) {
        if (super.mouseScrolled(context)) {
            return true;
        }
        if (this.area.isInside(context.mouseX, context.mouseY) && !this.scrolling) {
            int scroll = context.mouseWheel;
            if (!Minecraft.field_142025_a) {
                scroll = -scroll;
            }
            this.zoom(scroll, context.mouseX, context.mouseY);
            return true;
        }
        return false;
    }

    protected void zoom(int scroll, int mouseX, int mouseY) {
        this.scaleX.setShift(this.scaleX.from(mouseX));
        this.scaleX.zoom(Math.copySign(this.scaleX.getZoomFactor(), (double)scroll), this.minZoom, this.maxZoom);
        this.scaleX.setShift(2.0 * this.scaleX.getShift() - this.scaleX.from(mouseX));
    }

    @Override
    public void mouseReleased(GuiContext context) {
        super.mouseReleased(context);
        if (this.which == Selection.KEYFRAME) {
            if (this.sliding) {
                this.postSlideSort(context);
            }
            if (this.moving) {
                this.updateMoved();
            }
        }
        this.resetMouseReleased(context);
    }

    protected void postSlideSort(GuiContext context) {
    }

    protected void resetMouseReleased(GuiContext context) {
        this.grabbing = false;
        this.dragging = false;
        this.moving = false;
        this.scrolling = false;
    }

    @Override
    public void draw(GuiContext context) {
        this.handleMouse(context, context.mouseX, context.mouseY);
        this.drawBackground(context);
        GuiDraw.scissor(this.area.x, this.area.y, this.area.w, this.area.h, context);
        this.drawGrid(context);
        this.drawCursor(context);
        GlStateManager.func_187441_d((float)((float)Minecraft.func_71410_x().field_71474_y.field_74335_Z * 1.5f));
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.drawGraph(context, context.mouseX, context.mouseY);
        if (this.isGrabbing()) {
            Gui.func_73734_a((int)this.lastX, (int)this.lastY, (int)context.mouseX, (int)context.mouseY, (int)1140885759);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GuiDraw.unscissor(context);
        super.draw(context);
    }

    protected void drawBackground(GuiContext context) {
        this.area.draw(-2013265920);
        if (this.duration > 0) {
            int leftBorder = this.toGraphX(0.0);
            int rightBorder = this.toGraphX(this.duration);
            if (leftBorder > this.area.x) {
                Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)leftBorder, (int)(this.area.y + this.area.h), (int)-2013265920);
            }
            if (rightBorder < this.area.ex()) {
                Gui.func_73734_a((int)rightBorder, (int)this.area.y, (int)this.area.ex(), (int)(this.area.y + this.area.h), (int)-2013265920);
            }
        }
    }

    protected void drawGrid(GuiContext context) {
        int x;
        int mult = this.scaleX.getMult();
        int hx = this.duration / mult;
        int ht = (int)this.fromGraphX(this.area.x);
        for (int j = Math.max(ht / mult, 0); j <= hx && (x = this.toGraphX(j * mult)) < this.area.ex(); ++j) {
            String label = this.converter == null ? String.valueOf(j * mult) : this.converter.format(j * mult);
            Gui.func_73734_a((int)x, (int)this.area.y, (int)(x + 1), (int)this.area.ey(), (int)0x44FFFFFF);
            this.font.func_78276_b(label, x + 4, this.area.y + 4, 0xFFFFFF);
        }
    }

    protected abstract void drawGraph(GuiContext var1, int var2, int var3);

    protected void drawRect(BufferBuilder builder, int x, int y, int offset, int c) {
        COLOR.set(c, false);
        builder.func_181662_b((double)(x - offset), (double)(y + offset), 0.0).func_181666_a(GuiKeyframeElement.COLOR.r, GuiKeyframeElement.COLOR.g, GuiKeyframeElement.COLOR.b, 1.0f).func_181675_d();
        builder.func_181662_b((double)(x + offset), (double)(y + offset), 0.0).func_181666_a(GuiKeyframeElement.COLOR.r, GuiKeyframeElement.COLOR.g, GuiKeyframeElement.COLOR.b, 1.0f).func_181675_d();
        builder.func_181662_b((double)(x + offset), (double)(y - offset), 0.0).func_181666_a(GuiKeyframeElement.COLOR.r, GuiKeyframeElement.COLOR.g, GuiKeyframeElement.COLOR.b, 1.0f).func_181675_d();
        builder.func_181662_b((double)(x - offset), (double)(y - offset), 0.0).func_181666_a(GuiKeyframeElement.COLOR.r, GuiKeyframeElement.COLOR.g, GuiKeyframeElement.COLOR.b, 1.0f).func_181675_d();
    }

    protected void handleMouse(GuiContext context, int mouseX, int mouseY) {
        if (this.dragging && !this.moving && (Math.abs(this.lastX - mouseX) > 3 || Math.abs(this.lastY - mouseY) > 3)) {
            this.moving = true;
            this.sliding = true;
        }
        if (this.scrolling) {
            this.scrolling(mouseX, mouseY);
        } else if (this.moving && !this.grabbing) {
            this.setKeyframe(this.moving(context, mouseX, mouseY));
            this.keepMoving();
        }
    }

    protected void keepMoving() {
    }

    protected void scrolling(int mouseX, int mouseY) {
        this.scaleX.setShift((double)(-(mouseX - this.lastX)) / this.scaleX.getZoom() + this.lastT);
    }

    protected Keyframe moving(GuiContext context, int mouseX, int mouseY) {
        return null;
    }
}

