/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.input;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.multiskin.GuiMultiSkinEditor;
import mchorse.mclib.client.gui.framework.elements.list.GuiFolderEntryListElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Timer;
import mchorse.mclib.utils.files.FileTree;
import mchorse.mclib.utils.files.GlobalTree;
import mchorse.mclib.utils.files.entries.AbstractEntry;
import mchorse.mclib.utils.files.entries.FileEntry;
import mchorse.mclib.utils.files.entries.FolderEntry;
import mchorse.mclib.utils.resources.FilteredResourceLocation;
import mchorse.mclib.utils.resources.MultiResourceLocation;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiTexturePicker
extends GuiElement {
    public GuiElement right;
    public GuiTextElement text;
    public GuiButtonElement close;
    public GuiButtonElement folder;
    public GuiFolderEntryListElement picker;
    public GuiButtonElement multi;
    public GuiFRLListElement multiList;
    public GuiMultiSkinEditor editor;
    public GuiElement buttons;
    public GuiIconElement add;
    public GuiIconElement remove;
    public GuiIconElement edit;
    public Consumer<ResourceLocation> callback;
    public MultiResourceLocation multiRL;
    public FilteredResourceLocation currentFRL;
    public ResourceLocation current;
    public FileTree tree = GlobalTree.TREE;
    private Timer lastTyped = new Timer(1000L);
    private Timer lastChecked = new Timer(1000L);
    private String typed = "";

    public GuiTexturePicker(Minecraft mc, Consumer<ResourceLocation> callback) {
        super(mc);
        this.right = new GuiElement(mc);
        this.text = new GuiTextElement(mc, 1000, str -> this.selectCurrent(str.isEmpty() ? null : RLUtils.create(str)));
        this.text.context(() -> {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(mc);
            ResourceLocation location = this.parseRL();
            menu.action(Icons.COPY, IKey.lang("mclib.gui.context.multi_skin.copy"), this::copyRL);
            if (location != null) {
                menu.action(Icons.PASTE, IKey.lang("mclib.gui.context.multi_skin.paste"), () -> this.pasteRL(location));
            }
            return menu;
        });
        this.close = new GuiButtonElement(mc, IKey.str("X"), b -> this.close());
        this.folder = new GuiButtonElement(mc, IKey.lang("mclib.gui.open_folder"), b -> this.openFolder());
        this.picker = new GuiFolderEntryListElement(mc, entry -> {
            ResourceLocation rl = entry.resource;
            this.selectCurrent(rl);
            this.text.setText(rl == null ? "" : rl.toString());
        }){

            @Override
            public void setFolder(FolderEntry folder) {
                super.setFolder(folder);
                GuiTexturePicker.this.updateFolderButton();
            }
        };
        this.picker.cancelScrollEdge();
        this.multi = new GuiButtonElement(mc, IKey.lang("mclib.gui.multi_skin"), b -> this.toggleMultiSkin());
        this.multiList = new GuiFRLListElement(mc, list -> this.setFRL((FilteredResourceLocation)list.get(0)));
        this.editor = new GuiMultiSkinEditor(mc, this);
        this.editor.setVisible(false);
        this.buttons = new GuiElement(mc);
        this.add = new GuiIconElement(mc, Icons.ADD, b -> this.addMultiSkin());
        this.remove = new GuiIconElement(mc, Icons.REMOVE, b -> this.removeMultiSkin());
        this.edit = new GuiIconElement(mc, Icons.EDIT, b -> this.toggleEditor());
        this.right.flex().relative(this).wh(1.0f, 1.0f);
        this.text.flex().relative(this.multi).x(1.0f, 20).wTo((IResizer)this.close.flex(), -5).h(20);
        this.close.flex().relative(this).set(0.0f, 10.0f, 20.0f, 20.0f).x(1.0f, -30);
        this.folder.flex().relative(this.right).set(0.0f, 0.0f, 80.0f, 20.0f).x(1.0f, -10).y(1.0f, -10).anchor(1.0f, 1.0f);
        this.picker.flex().relative(this.right).set(10.0f, 30.0f, 0.0f, 0.0f).w(1.0f, -10).h(1.0f, -30);
        this.multi.flex().relative(this).set(10.0f, 10.0f, 100.0f, 20.0f);
        this.multiList.flex().relative(this).set(10.0f, 35.0f, 100.0f, 0.0f).hTo(this.buttons.flex());
        this.editor.flex().relative(this).set(120.0f, 0.0f, 0.0f, 0.0f).w(1.0f, -120).h(1.0f);
        this.buttons.flex().relative(this).y(1.0f, -20).wTo(this.right.area).h(20);
        this.add.flex().relative(this.buttons).set(0.0f, 0.0f, 20.0f, 20.0f);
        this.remove.flex().relative(this.add).set(20.0f, 0.0f, 20.0f, 20.0f);
        this.edit.flex().relative(this.buttons).wh(20, 20).x(1.0f, -20);
        this.right.add(this.text, this.picker, this.folder);
        this.buttons.add(this.add, this.remove, this.edit);
        this.add(this.multi, this.multiList, this.close, this.right, this.editor, this.buttons);
        this.callback = callback;
        this.fill(null);
        this.markContainer();
    }

    private ResourceLocation parseRL() {
        ResourceLocation location = null;
        try {
            NBTTagCompound compound = JsonToNBT.func_180713_a((String)GuiScreen.func_146277_j());
            location = RLUtils.create(compound.func_74781_a("RL"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return location;
    }

    private void copyRL() {
        NBTBase location = RLUtils.writeNbt(this.multiRL != null ? this.multiRL : this.current);
        if (location == null) {
            GuiScreen.func_146275_d((String)"");
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("RL", location);
            GuiScreen.func_146275_d((String)tag.toString());
        }
    }

    private void pasteRL(ResourceLocation location) {
        this.setMultiSkin(location, true);
    }

    public void close() {
        boolean wasVisible = this.getParent() != null;
        this.editor.close();
        this.removeFromParent();
        if (this.callback != null && wasVisible) {
            if (this.multiRL != null) {
                this.multiRL.recalculateId();
            }
            this.callback.accept(this.multiRL != null ? this.multiRL : this.current);
        }
    }

    public void refresh() {
        this.picker.update();
        this.updateFolderButton();
    }

    public void openFolder() {
        if (this.picker.parent != null && this.picker.parent.file != null) {
            GuiUtils.openFolder(this.picker.parent.file.getAbsolutePath());
        }
    }

    public void updateFolderButton() {
        this.folder.setEnabled(this.picker.parent != null && this.picker.parent.file != null);
    }

    public void fill(ResourceLocation skin) {
        this.setMultiSkin(skin, false);
    }

    private void addMultiSkin() {
        FilteredResourceLocation rl = this.currentFRL.copy();
        this.multiList.add(rl);
        this.multiList.setIndex(this.multiList.getList().size() - 1);
        this.setFRL((FilteredResourceLocation)this.multiList.getCurrent().get(0));
    }

    private void removeMultiSkin() {
        int index = this.multiList.getIndex();
        if (index >= 0 && this.multiList.getList().size() > 1) {
            this.multiList.getList().remove(index);
            this.multiList.update();
            this.multiList.setIndex(index - 1);
            if (this.multiList.getIndex() >= 0) {
                this.setFRL((FilteredResourceLocation)this.multiList.getCurrent().get(0));
            }
        }
    }

    private void setFRL(FilteredResourceLocation location) {
        this.currentFRL = location;
        this.displayCurrent(location.path);
        this.editor.setLocation(location);
    }

    private void toggleEditor() {
        this.editor.toggleVisible();
        this.right.setVisible(!this.editor.isVisible());
        if (this.editor.isVisible()) {
            this.editor.resetView();
        }
    }

    protected void displayCurrent(ResourceLocation rl) {
        FolderEntry folder;
        this.current = rl;
        this.picker.rl = rl;
        this.text.setText(rl == null ? "" : rl.toString());
        this.text.field.func_146196_d();
        if (this.tree != null && ((folder = this.tree.getByPath(rl == null ? "" : rl.func_110624_b() + "/" + rl.func_110623_a())) != this.tree.root || this.picker.getList().isEmpty())) {
            this.picker.setList(folder.getEntries());
            this.picker.parent = folder;
            this.picker.setCurrent(rl);
            this.picker.update();
            this.updateFolderButton();
        }
    }

    protected void selectCurrent(ResourceLocation rl) {
        try {
            if (rl != null) {
                this.mc.field_71446_o.func_110577_a(rl);
            }
        }
        catch (Exception e) {
            return;
        }
        this.current = rl;
        if (this.multiRL != null) {
            if (rl == null && this.multiRL.children.size() == 1) {
                this.currentFRL.path = rl;
                this.toggleMultiSkin();
            } else {
                this.currentFRL.path = rl;
            }
        } else if (this.callback != null) {
            this.callback.accept(rl);
        }
        this.picker.rl = rl;
    }

    protected void toggleMultiSkin() {
        if (this.multiRL != null) {
            this.setMultiSkin(this.multiRL.children.get((int)0).path, true);
        } else if (this.current != null) {
            this.setMultiSkin(new MultiResourceLocation(this.current.toString()), true);
        } else {
            ResourceLocation rl = this.picker.getCurrentResource();
            if (rl != null) {
                this.setMultiSkin(rl, true);
            }
        }
    }

    protected void setMultiSkin(ResourceLocation skin, boolean notify) {
        boolean show;
        if (this.editor.isVisible()) {
            this.toggleEditor();
        }
        if (show = skin instanceof MultiResourceLocation) {
            this.multiRL = ((MultiResourceLocation)skin).copy();
            this.setFRL(this.multiRL.children.get(0));
            this.multiList.setIndex(this.multiRL.children.isEmpty() ? -1 : 0);
            this.multiList.setList(this.multiRL.children);
            if (this.current != null) {
                this.multiList.setIndex(0);
            }
            this.right.flex().x(120).w(1.0f, -120);
        } else {
            this.multiRL = null;
            this.right.flex().x(0).w(1.0f);
            this.displayCurrent(skin);
        }
        if (notify) {
            if (show && this.callback != null) {
                this.multiRL.recalculateId();
                this.callback.accept(skin);
            } else {
                this.selectCurrent(skin);
            }
        }
        this.multiList.setVisible(show);
        this.buttons.setVisible(show);
        this.resize();
        this.updateFolderButton();
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        return super.mouseClicked(context) || this.isVisible() && this.area.isInside(context);
    }

    @Override
    public boolean keyTyped(GuiContext context) {
        if (super.keyTyped(context)) {
            return true;
        }
        int keyCode = context.keyCode;
        if (keyCode == 28) {
            AbstractEntry entry;
            List selected = this.picker.getCurrent();
            AbstractEntry abstractEntry = entry = selected.isEmpty() ? null : (AbstractEntry)selected.get(0);
            if (entry instanceof FolderEntry) {
                this.picker.setFolder((FolderEntry)entry);
            } else if (entry instanceof FileEntry) {
                this.selectCurrent(((FileEntry)entry).resource);
            }
            this.typed = "";
            return true;
        }
        if (keyCode == 200) {
            return this.moveCurrent(-1, GuiScreen.func_146272_n());
        }
        if (keyCode == 208) {
            return this.moveCurrent(1, GuiScreen.func_146272_n());
        }
        if (keyCode == 1) {
            this.close();
            return true;
        }
        return this.pickByTyping(context.typedChar);
    }

    protected boolean moveCurrent(int factor, boolean top) {
        int index = this.picker.getIndex() + factor;
        int length = this.picker.getList().size();
        if (index < 0) {
            index = length - 1;
        } else if (index >= length) {
            index = 0;
        }
        if (top) {
            index = factor > 0 ? length - 1 : 0;
        }
        this.picker.setIndex(index);
        this.picker.scroll.scrollIntoView(index * this.picker.scroll.scrollItemSize);
        this.typed = "";
        return true;
    }

    protected boolean pickByTyping(char typedChar) {
        if (!ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            return false;
        }
        if (this.lastTyped.checkReset()) {
            this.typed = "";
        }
        this.typed = this.typed + Character.toString(typedChar);
        this.lastTyped.mark();
        for (AbstractEntry entry : this.picker.getList()) {
            if (!entry.title.startsWith(this.typed)) continue;
            this.picker.setCurrentScroll(entry);
            return true;
        }
        return true;
    }

    @Override
    public void draw(GuiContext context) {
        if (this.lastChecked.checkRepeat()) {
            FolderEntry folder = this.picker.parent;
            if (folder != null && folder.isTop()) {
                folder = folder.top;
            }
            if (folder != null && folder.hasChanged()) {
                this.picker.setDirectFolder(folder);
            }
        }
        this.func_73733_a(this.area.x, this.area.y, this.area.ex(), this.area.ey(), -2013265920, -16777216);
        if (this.multiList.isVisible()) {
            GuiTexturePicker.func_73734_a((int)this.area.x, (int)this.area.y, (int)(this.area.x + 120), (int)this.area.ey(), (int)-15198184);
            GuiTexturePicker.func_73734_a((int)this.area.x, (int)this.area.y, (int)(this.area.x + 120), (int)(this.area.y + 30), (int)0x44000000);
            this.func_73733_a(this.area.x, this.area.ey() - 20, this.buttons.area.ex(), this.area.ey(), 0, -2013265920);
        }
        if (this.editor.isVisible()) {
            this.edit.area.draw(-2013265920 + (Integer)McLib.primaryColor.get());
        }
        super.draw(context);
        if (this.right.isVisible()) {
            ResourceLocation loc;
            if (this.picker.getList().isEmpty()) {
                this.func_73732_a(this.font, I18n.func_135052_a((String)"mclib.gui.no_data", (Object[])new Object[0]), this.picker.area.mx(), this.picker.area.my() - 8, 0xFFFFFF);
            }
            if (!this.lastTyped.check() && this.lastTyped.enabled) {
                int w = this.font.func_78256_a(this.typed);
                int x = this.text.area.x;
                int y = this.text.area.ey();
                Gui.func_73734_a((int)x, (int)y, (int)(x + w + 4), (int)(y + 4 + this.font.field_78288_b), (int)(-2013265920 + (Integer)McLib.primaryColor.get()));
                this.font.func_175063_a(this.typed, (float)(x + 2), (float)(y + 2), 0xFFFFFF);
            }
            if ((loc = this.current) != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.field_71446_o.func_110577_a(loc);
                int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                int x = this.area.ex();
                int y = this.area.ey();
                int fw = w;
                int fh = h;
                if (fw > 128 || fh > 128) {
                    fh = 128;
                    fw = 128;
                    if (w > h) {
                        fh = (int)((float)h / (float)w * (float)fw);
                    } else if (h > w) {
                        fw = (int)((float)w / (float)h * (float)fh);
                    }
                }
                Icons.CHECKBOARD.renderArea(x -= fw + 10, y -= fh + 35, fw, fh);
                GlStateManager.func_179141_d();
                this.mc.field_71446_o.func_110577_a(loc);
                GuiDraw.drawBillboard(x, y, 0, 0, fw, fh, fw, fh);
            }
        }
    }

    public static class GuiFRLListElement
    extends GuiListElement<FilteredResourceLocation> {
        public GuiFRLListElement(Minecraft mc, Consumer<List<FilteredResourceLocation>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 16;
        }

        @Override
        protected boolean sortElements() {
            Collections.sort(this.list, (a, b) -> a.toString().compareToIgnoreCase(b.toString()));
            return true;
        }
    }
}

