/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.nckey.mixin;

import com.google.common.collect.Sets;
import committee.nova.nckey.api.IKeyBindingMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.IntHashMap;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.client.settings.KeyModifier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={KeyBindingMap.class})
public abstract class MixinKeyBindingMap
implements IKeyBindingMap {
    @Shadow(remap=false)
    @Final
    private static EnumMap<KeyModifier, IntHashMap<Collection<KeyBinding>>> map;

    @Override
    public Set<KeyBinding> lookupActives(int keyCode) {
        Set<KeyBinding> bindings;
        KeyModifier activeModifier = KeyModifier.getActiveModifier();
        if (!activeModifier.matches(keyCode) && !(bindings = this.getBindings(keyCode, activeModifier)).isEmpty()) {
            return bindings;
        }
        return this.getBindings(keyCode, KeyModifier.NONE);
    }

    @Override
    public Set<KeyBinding> getBindings(int keyCode, KeyModifier keyModifier) {
        Collection bindings = (Collection)map.get(keyModifier).func_76041_a(keyCode);
        HashSet toReturn = Sets.newHashSet();
        if (bindings == null) {
            return toReturn;
        }
        for (KeyBinding binding : bindings) {
            if (!binding.isActiveAndMatches(keyCode)) continue;
            toReturn.add(binding);
        }
        return toReturn;
    }
}

