/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.client.renderer.entity;

import goblinbob.mobends.core.client.model.ModelPartTransform;
import goblinbob.mobends.core.math.Quaternion;
import goblinbob.mobends.core.math.QuaternionUtils;
import goblinbob.mobends.core.math.SmoothOrientation;
import goblinbob.mobends.core.math.vector.IVec3f;
import goblinbob.mobends.core.math.vector.Vec3f;
import goblinbob.mobends.core.util.GUtil;
import goblinbob.mobends.core.util.IColorRead;
import goblinbob.mobends.standard.data.BipedEntityData;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Supplier;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.opengl.GL11;

public class SwordTrail {
    protected final Supplier<IColorRead> baseColor;
    protected LinkedList<TrailPart> trailPartList = new LinkedList();
    public static Vector3f XP = new Vector3f(1.0f, 0.0f, 0.0f);
    public static Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
    public static Vector3f ZP = new Vector3f(0.0f, 0.0f, 1.0f);

    public SwordTrail(Supplier<IColorRead> baseColor) {
        this.baseColor = baseColor;
    }

    public void reset() {
        this.trailPartList.clear();
    }

    public void render() {
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GL11.glHint((int)3152, (int)4354);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179094_E();
        GlStateManager.func_187447_r((int)7);
        Iterator it = this.trailPartList.iterator();
        boolean first = true;
        while (it.hasNext()) {
            TrailPart part = (TrailPart)it.next();
            part.draw(first, !it.hasNext());
            first = false;
        }
        GlStateManager.func_187437_J();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179129_p();
        GlStateManager.func_179145_e();
    }

    public void add(BipedEntityData<?> entityData, float velocityX, float velocityY, float velocityZ) {
        Quaternion quaternion;
        Object entity = entityData.getEntity();
        EnumHandSide primaryHand = entity.func_184591_cq();
        IColorRead colorRead = this.baseColor.get();
        Object entity1 = entityData.getEntity();
        float length = 8.0f;
        if (entity1 != null && !entity1.func_184614_ca().func_190926_b()) {
            NBTTagCompound tagCompound = entity1.func_184614_ca().func_77978_p();
            if (tagCompound != null && tagCompound.func_150297_b("trailLength", 99)) {
                length = tagCompound.func_74762_e("trailLength");
            }
            if (tagCompound != null && tagCompound.func_150297_b("trailLength", 8)) {
                length = NumberUtils.toInt((String)tagCompound.func_74779_i("trailLength"));
            }
            if (tagCompound != null && tagCompound.func_74764_b("trailColor")) {
                String trailColor = tagCompound.func_74779_i("trailColor");
                colorRead = this.to(trailColor);
            }
        }
        TrailPart newPart = new TrailPart(primaryHand, length, colorRead, velocityX, velocityY, velocityZ);
        newPart.body.syncUp(entityData.body);
        if (primaryHand == EnumHandSide.RIGHT) {
            newPart.arm.syncUp(entityData.rightArm);
            newPart.foreArm.syncUp(entityData.rightForeArm);
            if (entityData.rightItemRotation.isNotEmpty()) {
                quaternion = new Quaternion();
                quaternion.rotate(1.0f, 0.0f, 0.0f, (float)(entityData.rightItemRotation.x / 180.0 * Math.PI));
                quaternion.rotate(0.0f, 1.0f, 0.0f, (float)(entityData.rightItemRotation.y / 180.0 * Math.PI));
                quaternion.rotate(0.0f, 0.0f, 1.0f, (float)(entityData.rightItemRotation.z / 180.0 * Math.PI));
                newPart.itemRotation.set(quaternion);
                newPart.translation.set((float)entityData.rightItemOffset.x, (float)entityData.rightItemOffset.y, (float)entityData.rightItemOffset.z);
            } else {
                newPart.itemRotation.set(entityData.renderRightItemRotation.getSmooth());
            }
        } else {
            newPart.arm.syncUp(entityData.leftArm);
            newPart.foreArm.syncUp(entityData.leftForeArm);
            if (entityData.leftItemRotation.isNotEmpty()) {
                quaternion = new Quaternion();
                quaternion.rotate(1.0f, 0.0f, 0.0f, (float)(entityData.leftItemRotation.x / 180.0 * Math.PI));
                quaternion.rotate(0.0f, 1.0f, 0.0f, (float)(entityData.leftItemRotation.y / 180.0 * Math.PI));
                quaternion.rotate(0.0f, 0.0f, 1.0f, (float)(entityData.leftItemRotation.z / 180.0 * Math.PI));
                newPart.itemRotation.set(quaternion);
                newPart.translation.set((float)entityData.leftItemOffset.x, (float)entityData.leftItemOffset.y, (float)entityData.leftItemOffset.z);
            } else {
                newPart.itemRotation.set(entityData.renderLeftItemRotation.getSmooth());
            }
            QuaternionUtils.rotate(newPart.itemRotation, 90.0f, 0.0f, 1.0f, 0.0f);
        }
        newPart.renderOffset.set(entityData.globalOffset.getX(), entityData.globalOffset.getY(), entityData.globalOffset.getZ());
        newPart.renderRotation.set(entityData.renderRotation.getSmooth());
        newPart.renderRotation.negate();
        newPart.centerRotation.set(entityData.centerRotation.getSmooth());
        newPart.centerRotation.y = -newPart.centerRotation.y;
        newPart.centerRotation.z = -newPart.centerRotation.z;
        this.trailPartList.add(newPart);
    }

    public IColorRead to(String str) {
        String[] split = str.split(",");
        if (split.length == 4) {
            final float r2 = (float)NumberUtils.toInt((String)split[0]) / 255.0f;
            final float g2 = (float)NumberUtils.toInt((String)split[1]) / 255.0f;
            final float b2 = (float)NumberUtils.toInt((String)split[2]) / 255.0f;
            final float a2 = (float)NumberUtils.toInt((String)split[3]) / 255.0f;
            return new IColorRead(){

                @Override
                public float getR() {
                    return r2;
                }

                @Override
                public float getG() {
                    return g2;
                }

                @Override
                public float getB() {
                    return b2;
                }

                @Override
                public float getA() {
                    return a2;
                }
            };
        }
        return this.baseColor.get();
    }

    public void add(BipedEntityData<?> entityData) {
        this.add(entityData, 0.0f, 0.0f, 0.0f);
    }

    public void update(float ticksPerFrame) {
        Iterator it = this.trailPartList.iterator();
        while (it.hasNext()) {
            TrailPart trailPart = (TrailPart)it.next();
            trailPart.update(ticksPerFrame);
            if (!(trailPart.ticksExisted > 20.0f)) continue;
            it.remove();
        }
    }

    protected static class TrailPart {
        protected EnumHandSide primaryHand;
        protected IColorRead baseColor;
        protected ModelPartTransform root;
        protected ModelPartTransform body;
        protected ModelPartTransform arm;
        protected ModelPartTransform foreArm;
        protected Quaternion centerRotation = new Quaternion();
        private float height;
        protected Quaternion renderRotation = new Quaternion();
        protected Vec3f renderOffset = new Vec3f();
        protected Quaternion itemRotation = new Quaternion();
        protected Vec3f rotation = new Vec3f();
        protected Vec3f translation = new Vec3f();
        protected Vec3f position = new Vec3f();
        protected float velocityX;
        protected float velocityY;
        protected float velocityZ;
        protected float ticksExisted = 0.0f;
        private final float length;

        public TrailPart(EnumHandSide primaryHand, float length, IColorRead baseColor, float velocityX, float velocityY, float velocityZ) {
            this.length = length;
            this.root = new ModelPartTransform();
            this.body = new ModelPartTransform();
            this.arm = new ModelPartTransform();
            this.foreArm = new ModelPartTransform();
            this.primaryHand = primaryHand;
            this.baseColor = baseColor;
            this.velocityX = velocityX;
            this.velocityY = velocityY;
            this.velocityZ = velocityZ;
        }

        public void update(float ticksPerFrame) {
            this.ticksExisted += ticksPerFrame;
            this.position.x += this.velocityX * ticksPerFrame;
            this.position.y += this.velocityY * ticksPerFrame;
            this.position.z += this.velocityZ * ticksPerFrame;
        }

        private void rotate(Vec3f[] points, ModelPartTransform part, float f2) {
            if (part.isApplyAnimation()) {
                SmoothOrientation smoothOrientation = new SmoothOrientation();
                smoothOrientation.rotateX(part.getRotateAngle().getX());
                smoothOrientation.rotateY(part.getRotateAngle().getY());
                smoothOrientation.rotateZ(part.getRotateAngle().getZ());
                smoothOrientation.finish();
                GUtil.rotate(points, smoothOrientation.getSmooth());
            } else {
                GUtil.rotate(points, part.rotation.getSmooth());
            }
        }

        public void draw(boolean first, boolean last) {
            float alpha = this.ticksExisted / 5.0f;
            alpha = Math.min(alpha, 1.0f);
            alpha = 1.0f - alpha;
            float xxx = this.primaryHand == EnumHandSide.LEFT ? 1.1f : 1.0f;
            float length = this.length * xxx;
            IVec3f[] points = new Vec3f[]{new Vec3f(0.0f, 0.0f, -length + length * alpha), new Vec3f(0.0f, 0.0f, -length - length * alpha)};
            GUtil.translate(points, 0.0f, 0.0f, length * 2.0f);
            GUtil.rotate(points, this.itemRotation);
            GUtil.translate(points, this.translation.x * 0.0625f, this.translation.y * 0.0625f, this.translation.z * 0.0625f);
            GUtil.translate(points, -1.0f, -6.0f, 0.0f);
            this.rotate((Vec3f[])points, this.foreArm, -1.0f);
            GUtil.translate(points, 0.0f, -4.0f, 0.0f);
            this.rotate((Vec3f[])points, this.arm, -1.0f);
            GUtil.translate(points, this.arm.position.x, 10.0f, 0.0f);
            this.rotate((Vec3f[])points, this.body, 1.0f);
            GUtil.translate(points, 0.0f, 12.0f, 0.0f);
            GUtil.translate(points, 0.0f, -0.75f, 0.125f);
            GUtil.rotate(points, this.centerRotation);
            GUtil.translate(points, 0.0f, 0.75f, -0.125f);
            GUtil.rotate(points, this.renderRotation);
            GUtil.translate(points, this.renderOffset.x, this.renderOffset.y, this.renderOffset.z);
            for (IVec3f point : points) {
                point.add(this.position);
            }
            GlStateManager.func_179131_c((float)this.baseColor.getR(), (float)this.baseColor.getG(), (float)this.baseColor.getB(), (float)alpha);
            if (!first) {
                GlStateManager.func_187435_e((float)((Vec3f)points[1]).x, (float)((Vec3f)points[1]).y, (float)((Vec3f)points[1]).z);
                GlStateManager.func_187435_e((float)((Vec3f)points[0]).x, (float)((Vec3f)points[0]).y, (float)((Vec3f)points[0]).z);
            }
            GlStateManager.func_187435_e((float)((Vec3f)points[0]).x, (float)((Vec3f)points[0]).y, (float)((Vec3f)points[0]).z);
            GlStateManager.func_187435_e((float)((Vec3f)points[1]).x, (float)((Vec3f)points[1]).y, (float)((Vec3f)points[1]).z);
            if (last) {
                GlStateManager.func_187435_e((float)((Vec3f)points[1]).x, (float)((Vec3f)points[1]).y, (float)((Vec3f)points[1]).z);
                GlStateManager.func_187435_e((float)((Vec3f)points[0]).x, (float)((Vec3f)points[0]).y, (float)((Vec3f)points[0]).z);
            }
        }
    }
}

