/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.event;

import goblinbob.mobends.core.bender.EntityBender;
import goblinbob.mobends.core.bender.EntityBenderRegistry;
import goblinbob.mobends.core.data.EntityData;
import goblinbob.mobends.core.mutators.Mutator;
import goblinbob.mobends.dragon.AnimationHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityRenderHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void beforeLivingRenderNameTag(RenderLivingEvent.Specials.Pre<EntityLivingBase> event) {
        if (event.isCanceled()) {
            return;
        }
        EntityLivingBase living = event.getEntity();
        if (living instanceof EntityPlayer) {
            Mutator<?, ?, ?> mutator;
            EntityBender<EntityLivingBase> entityBender = EntityBenderRegistry.instance.getForEntity(living);
            if (entityBender == null) {
                return;
            }
            RenderLivingBase renderer = event.getRenderer();
            float pt = event.getPartialRenderTick();
            if (entityBender.isAnimated() && (mutator = entityBender.getMutator((RenderLivingBase<EntityLivingBase>)renderer)) != null) {
                Object data = mutator.getData(living);
                entityBender.backtrackBeforeRender((EntityData<EntityLivingBase>)data, (EntityPlayer)living, pt);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void beforeLivingRender(RenderPlayerEvent.Pre event) {
        EntityRenderHandler.beforeRender(event.getEntityLiving(), (RenderLivingBase)event.getRenderer(), event.getPartialRenderTick());
    }

    @SubscribeEvent
    public void afterLivingRender(RenderPlayerEvent.Post event) {
        EntityRenderHandler.postRender(event.getEntityLiving(), (RenderLivingBase)event.getRenderer(), event.getPartialRenderTick());
    }

    public static void beforeRender(EntityLivingBase living, RenderLivingBase renderer, float pt) {
        EntityBender<EntityLivingBase> entityBender = EntityBenderRegistry.instance.getForEntity(living);
        if (entityBender == null) {
            return;
        }
        GlStateManager.func_179094_E();
        if (entityBender.isAnimated()) {
            AnimationHelper.postRender(living, renderer);
            AnimationHelper.preRender(living, renderer);
            if (entityBender.applyMutation((RenderLivingBase<EntityLivingBase>)renderer, living, pt)) {
                Mutator<?, ?, ?> mutator = entityBender.getMutator((RenderLivingBase<EntityLivingBase>)renderer);
                Object data = mutator.getData(living);
                entityBender.beforeRender((EntityData<EntityLivingBase>)data, living, pt);
            }
        } else {
            entityBender.deapplyMutation((RenderLivingBase<EntityLivingBase>)renderer, living);
        }
    }

    public static void postRender(EntityLivingBase living, RenderLivingBase renderer, float pt) {
        EntityBender<EntityLivingBase> entityBender = EntityBenderRegistry.instance.getForEntity(living);
        if (entityBender == null) {
            return;
        }
        entityBender.afterRender(living, pt);
        AnimationHelper.postRender(living, renderer);
        GlStateManager.func_179121_F();
    }
}

